/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.healthcheck.servlet;

import java.io.IOException;
import java.net.URL;
import java.util.Base64;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.karaf.jaas.boot.principal.RolePrincipal;
import org.apache.karaf.jaas.boot.principal.UserPrincipal;
import org.apache.unomi.healthcheck.servlet.HealthCheckAuthorization;
import org.osgi.service.http.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealthCheckHttpContext
implements HttpContext {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)HealthCheckHttpContext.class.getName());
    private final String realm;

    public HealthCheckHttpContext(String realm) {
        this.realm = realm;
    }

    public boolean handleSecurity(HttpServletRequest req, HttpServletResponse res) throws IOException {
        if (req.getHeader("Authorization") == null) {
            LOGGER.debug("No Authorization header found, sending 401");
            res.addHeader("WWW-Authenticate", "Basic realm=\"" + this.realm + "\"");
            res.sendError(401);
            return false;
        }
        if (this.authenticated(req)) {
            LOGGER.debug("User authenticated, allowing access");
            return true;
        }
        LOGGER.debug("User not authenticated, sending 401");
        res.sendError(401);
        return false;
    }

    protected boolean authenticated(HttpServletRequest request) {
        request.setAttribute("org.osgi.service.http.authentication.type", (Object)"BASIC");
        String authzHeader = request.getHeader("Authorization");
        String usernameAndPassword = new String(Base64.getDecoder().decode(authzHeader.substring(6).getBytes()));
        String[] parts = usernameAndPassword.split(":");
        LOGGER.debug("Authenticating user {}", (Object)parts[0]);
        try {
            LOGGER.debug("Creating Login Context for realm {}", (Object)this.realm);
            LoginContext loginContext = new LoginContext(this.realm, callbacks -> {
                for (Callback callback : callbacks) {
                    if (callback instanceof NameCallback) {
                        ((NameCallback)callback).setName(parts[0]);
                        continue;
                    }
                    if (callback instanceof PasswordCallback) {
                        ((PasswordCallback)callback).setPassword(parts[1].toCharArray());
                        continue;
                    }
                    throw new UnsupportedCallbackException(callback);
                }
            });
            LOGGER.debug("Login Context created");
            loginContext.login();
            LOGGER.debug("Login Context called");
            if (loginContext.getSubject() != null) {
                LOGGER.debug("User authenticated, subject is not null {}", (Object)loginContext.getSubject());
                String username = loginContext.getSubject().getPrincipals(UserPrincipal.class).stream().map(UserPrincipal::getName).findFirst().orElse("unknown");
                String[] roles = (String[])loginContext.getSubject().getPrincipals(RolePrincipal.class).stream().map(RolePrincipal::getName).toArray(String[]::new);
                LOGGER.debug("User {} authenticated with roles {}", (Object)username, (Object)roles);
                request.setAttribute("org.osgi.service.http.authentication.remote.user", (Object)username);
                request.setAttribute("org.osgi.service.useradmin.authorization", (Object)new HealthCheckAuthorization(username, roles));
                return true;
            }
        }
        catch (Exception e) {
            LOGGER.error("Error while authenticating user", (Throwable)e);
        }
        return false;
    }

    public URL getResource(String s) {
        return null;
    }

    public String getMimeType(String s) {
        return null;
    }
}

