/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.war.internal;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import org.ops4j.pax.web.service.spi.context.DefaultServletContextHelper;
import org.ops4j.pax.web.service.spi.util.Path;
import org.ops4j.pax.web.utils.ClassPathUtil;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebApplicationHelper
extends DefaultServletContextHelper {
    public static final Logger LOG = LoggerFactory.getLogger(WebApplicationHelper.class);
    private final Map<Bundle, URL> metainfResourceRoots;

    public WebApplicationHelper(Bundle runtimeBundle, Map<Bundle, URL> metainfResourceRoots) {
        super(runtimeBundle);
        this.metainfResourceRoots = metainfResourceRoots;
    }

    public URL getResource(String name) {
        if ("/".equals(name)) {
            return super.getResource(name);
        }
        Enumeration e = null;
        String normalizedPath = Path.normalizeResourcePath((String)name);
        normalizedPath = normalizedPath.replace("\\", "\\\\").replace("*", "\\*");
        String root = null;
        String path = null;
        if (!normalizedPath.contains("/")) {
            root = "/";
            path = normalizedPath;
        } else {
            int lastSlash = normalizedPath.lastIndexOf(47);
            if (lastSlash == normalizedPath.length() - 1) {
                if (!(normalizedPath = normalizedPath.substring(0, normalizedPath.length() - 1)).contains("/")) {
                    root = "/";
                    path = normalizedPath;
                } else {
                    lastSlash = normalizedPath.lastIndexOf(47);
                    root = normalizedPath.substring(0, lastSlash);
                    path = normalizedPath.substring(lastSlash + 1);
                }
            } else {
                root = normalizedPath.substring(0, lastSlash);
                path = normalizedPath.substring(lastSlash + 1);
            }
        }
        e = this.bundle.findEntries(root, path, false);
        if (e != null) {
            return (URL)e.nextElement();
        }
        try {
            for (Map.Entry<Bundle, URL> entry : this.metainfResourceRoots.entrySet()) {
                List entries = ClassPathUtil.findEntries((Bundle)entry.getKey(), (URL[])new URL[]{entry.getValue()}, (String)root, (String)path, (boolean)false);
                if (entries.size() <= 0) continue;
                return (URL)entries.get(0);
            }
        }
        catch (IOException ex) {
            LOG.warn("Error accessing {}/{} from META-INF/resources: {}", new Object[]{root, path, ex.getMessage(), ex});
        }
        return null;
    }
}

