/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml.job.util;

import java.io.IOException;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import org.elasticsearch.common.time.DateFormatters;
import org.elasticsearch.common.xcontent.XContentParser;

public final class TimeUtil {
    public static Date parseTimeField(XContentParser parser, String fieldName) throws IOException {
        if (parser.currentToken() == XContentParser.Token.VALUE_NUMBER) {
            return new Date(parser.longValue());
        }
        if (parser.currentToken() == XContentParser.Token.VALUE_STRING) {
            return new Date(DateFormatters.from(DateTimeFormatter.ISO_INSTANT.parse(parser.text())).toInstant().toEpochMilli());
        }
        throw new IllegalArgumentException("unexpected token [" + (Object)((Object)parser.currentToken()) + "] for [" + fieldName + "]");
    }
}

