/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.cellar.core.command;

import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.karaf.cellar.core.Node;
import org.apache.karaf.cellar.core.Producer;
import org.apache.karaf.cellar.core.command.Command;
import org.apache.karaf.cellar.core.command.CommandStore;
import org.apache.karaf.cellar.core.command.ExecutionContext;
import org.apache.karaf.cellar.core.command.Result;
import org.apache.karaf.cellar.core.command.TimeoutTask;
import org.apache.karaf.cellar.core.exception.ProducerNotFoundException;
import org.apache.karaf.cellar.core.exception.StoreNotFoundException;

public class ClusteredExecutionContext
implements ExecutionContext {
    private Producer producer;
    private CommandStore commandStore;
    private ScheduledExecutorService timeoutScheduler = new ScheduledThreadPoolExecutor(10);

    public ClusteredExecutionContext() {
    }

    public ClusteredExecutionContext(Producer producer, CommandStore commandStore) {
        this.producer = producer;
        this.commandStore = commandStore;
    }

    @Override
    public <R extends Result, C extends Command<R>> Map<Node, R> execute(C command) throws StoreNotFoundException, ProducerNotFoundException, InterruptedException {
        if (command == null) {
            throw new StoreNotFoundException("Command store not found");
        }
        this.commandStore.getPending().put(command.getId(), command);
        TimeoutTask timeoutTask = new TimeoutTask(command, this.commandStore);
        this.timeoutScheduler.schedule(timeoutTask, command.getTimeout(), TimeUnit.MILLISECONDS);
        if (this.producer != null) {
            this.producer.produce(command);
            return command.getResult();
        }
        throw new ProducerNotFoundException("Command producer not found");
    }

    public Producer getProducer() {
        return this.producer;
    }

    public void setProducer(Producer producer) {
        this.producer = producer;
    }

    public CommandStore getCommandStore() {
        return this.commandStore;
    }

    public void setCommandStore(CommandStore commandStore) {
        this.commandStore = commandStore;
    }
}

