/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.karaf.commands;

import java.util.List;
import org.apache.cxf.Bus;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.endpoint.ServerRegistry;
import org.apache.cxf.karaf.commands.completers.BusCompleter;
import org.apache.cxf.karaf.commands.completers.StoppedEndpointCompleter;
import org.apache.cxf.karaf.commands.internal.CXFController;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.lifecycle.Service;

@Command(scope="cxf", name="start-endpoint", description="Starts a CXF Endpoint on a Bus.")
@Service
public class StartEndpointCommand
extends CXFController
implements Action {
    @Argument(index=0, name="bus", description="The CXF bus name where to look for the Endpoint", required=true, multiValued=false)
    @Completion(value=BusCompleter.class)
    String busName;
    @Argument(index=1, name="endpoint", description="The Endpoint name to start", required=true, multiValued=false)
    @Completion(value=StoppedEndpointCompleter.class)
    String endpoint;

    public Object execute() throws Exception {
        Bus b = this.getBus(this.busName);
        ServerRegistry reg = (ServerRegistry)b.getExtension(ServerRegistry.class);
        List servers = reg.getServers();
        for (Server serv : servers) {
            if (!this.endpoint.equals(serv.getEndpoint().getEndpointInfo().getName().getLocalPart())) continue;
            serv.start();
        }
        return null;
    }
}

