/*
 * Decompiled with CFR 0.152.
 */
package groovyx.net.http;

import groovy.lang.GString;
import groovyx.net.http.Form;
import groovyx.net.http.Traverser;
import java.io.IOException;
import java.net.HttpCookie;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.codehaus.groovy.runtime.GStringImpl;

public abstract class UriBuilder {
    public static final int DEFAULT_PORT = -1;
    private static final Object[] EMPTY = new Object[0];
    private Boolean useRawValues;

    public abstract UriBuilder setScheme(String var1);

    public abstract String getScheme();

    public abstract UriBuilder setPort(int var1);

    public abstract int getPort();

    public abstract UriBuilder setHost(String var1);

    public abstract String getHost();

    public abstract UriBuilder setPath(GString var1);

    public abstract GString getPath();

    public abstract UriBuilder setQuery(Map<String, ?> var1);

    public abstract Map<String, ?> getQuery();

    public abstract UriBuilder setFragment(String var1);

    public abstract String getFragment();

    public abstract UriBuilder setUserInfo(String var1);

    public abstract String getUserInfo();

    public abstract UriBuilder getParent();

    public UriBuilder setPath(String str) {
        String[] parts;
        if (str.startsWith("/")) {
            parts = new String[]{str};
        } else {
            String base = this.getPath().toString();
            parts = new String[]{base, base.endsWith("/") ? "" : "/", str};
        }
        return this.setPath((GString)new GStringImpl(EMPTY, parts));
    }

    public URI forCookie(HttpCookie cookie) throws URISyntaxException {
        String scheme = Traverser.traverse(this, UriBuilder::getParent, UriBuilder::getScheme, Traverser::notNull);
        Integer port = Traverser.traverse(this, UriBuilder::getParent, UriBuilder::getPort, Traverser.notValue(-1));
        String host = Traverser.traverse(this, UriBuilder::getParent, UriBuilder::getHost, Traverser::notNull);
        String path = cookie.getPath();
        String query = null;
        String fragment = null;
        String userInfo = null;
        return new URI(scheme, userInfo, host, port == null ? -1 : port, path, query, fragment);
    }

    public URI toURI() throws URISyntaxException {
        String scheme = Traverser.traverse(this, UriBuilder::getParent, UriBuilder::getScheme, Traverser::notNull);
        Integer port = Traverser.traverse(this, UriBuilder::getParent, UriBuilder::getPort, Traverser.notValue(-1));
        String host = Traverser.traverse(this, UriBuilder::getParent, UriBuilder::getHost, Traverser::notNull);
        GString path = Traverser.traverse(this, UriBuilder::getParent, UriBuilder::getPath, Traverser::notNull);
        String query = UriBuilder.populateQueryString(Traverser.traverse(this, UriBuilder::getParent, UriBuilder::getQuery, Traverser::nonEmptyMap));
        String fragment = Traverser.traverse(this, UriBuilder::getParent, UriBuilder::getFragment, Traverser::notNull);
        String userInfo = Traverser.traverse(this, UriBuilder::getParent, UriBuilder::getUserInfo, Traverser::notNull);
        Boolean useRaw = Traverser.traverse(this, UriBuilder::getParent, UriBuilder::getUseRawValues, Traverser::notNull);
        if (useRaw != null && useRaw.booleanValue()) {
            return this.toRawURI(scheme, port, host, path, query, fragment, userInfo);
        }
        return new URI(scheme, userInfo, host, port == null ? -1 : port, path == null ? null : path.toString(), query, fragment);
    }

    private URI toRawURI(String scheme, Integer port, String host, GString path, String query, String fragment, String userInfo) throws URISyntaxException {
        Object[] objectArray = new Object[7];
        Object object = scheme == null ? "" : (objectArray[0] = scheme.endsWith("://") ? scheme : scheme + "://");
        objectArray[1] = userInfo == null ? "" : (userInfo.endsWith("@") ? userInfo : userInfo + "@");
        objectArray[2] = host == null ? "" : host;
        Object object2 = objectArray[3] = port == null ? "" : ":" + port.toString();
        objectArray[4] = path == null ? "" : (!path.toString().startsWith("/") && !path.toString().isEmpty() ? "/" + path : path);
        Object object3 = objectArray[5] = query != null ? "?" + query : "";
        objectArray[6] = fragment == null ? "" : (!fragment.startsWith("#") ? "#" + fragment : fragment);
        return new URI(String.format("%s%s%s%s%s%s%s", objectArray));
    }

    private static String populateQueryString(Map<String, ?> queryMap) {
        if (queryMap == null || queryMap.isEmpty()) {
            return null;
        }
        LinkedList nvps = new LinkedList();
        queryMap.entrySet().forEach(entry -> {
            List<String> values;
            List<String> list = values = entry.getValue() instanceof Collection ? (List<String>)entry.getValue() : Collections.singletonList(entry.getValue().toString());
            if (values.isEmpty()) {
                nvps.add(entry.getKey());
            } else {
                values.forEach(value -> nvps.add((String)entry.getKey() + "=" + value));
            }
        });
        return nvps.stream().collect(Collectors.joining("&"));
    }

    public void setUseRawValues(boolean useRaw) {
        this.useRawValues = useRaw;
    }

    public Boolean getUseRawValues() {
        return this.useRawValues;
    }

    protected final void populateFrom(URI uri) {
        boolean useRaw = this.useRawValues != null ? this.useRawValues : false;
        try {
            String rawQuery;
            String path;
            this.setScheme(uri.getScheme());
            this.setPort(uri.getPort());
            this.setHost(uri.getHost());
            String string = path = useRaw ? uri.getRawPath() : uri.getPath();
            if (path != null) {
                this.setPath((GString)new GStringImpl(EMPTY, new String[]{path}));
            }
            String string2 = rawQuery = useRaw ? uri.getRawQuery() : uri.getQuery();
            if (rawQuery != null) {
                if (useRaw) {
                    this.setQuery(UriBuilder.extractQueryMap(rawQuery));
                } else {
                    this.setQuery(Form.decode(new StringBuilder(rawQuery), StandardCharsets.UTF_8));
                }
            }
            this.setFragment(useRaw ? uri.getRawFragment() : uri.getFragment());
            this.setUserInfo(useRaw ? uri.getRawUserInfo() : uri.getUserInfo());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static Map<String, Collection<String>> extractQueryMap(String queryString) {
        HashMap<String, Collection<String>> map = new HashMap<String, Collection<String>>();
        for (String nvp : queryString.split("&")) {
            String[] pair = nvp.split("=");
            map.computeIfAbsent(pair[0], k -> {
                LinkedList<String> list = new LinkedList<String>();
                list.add(pair[1]);
                return list;
            });
        }
        return map;
    }

    public final UriBuilder setFull(String str) {
        try {
            return this.setFull(new URI(str));
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex.getMessage());
        }
    }

    public final UriBuilder setFull(URI uri) {
        this.populateFrom(uri);
        return this;
    }

    public static UriBuilder basic(UriBuilder parent) {
        return new Basic(parent);
    }

    public static UriBuilder threadSafe(UriBuilder parent) {
        return new ThreadSafe(parent);
    }

    public static UriBuilder root() {
        return new ThreadSafe(null);
    }

    private static final class ThreadSafe
    extends UriBuilder {
        private volatile String scheme;
        private volatile int port = -1;
        private volatile String host;
        private volatile GString path;
        private Map<String, Object> query = new ConcurrentHashMap<String, Object>();
        private volatile String fragment;
        private volatile String userInfo;
        private final UriBuilder parent;

        @Override
        public UriBuilder setScheme(String val) {
            this.scheme = val;
            return this;
        }

        @Override
        public String getScheme() {
            return this.scheme;
        }

        @Override
        public UriBuilder setPort(int val) {
            this.port = val;
            return this;
        }

        @Override
        public int getPort() {
            return this.port;
        }

        @Override
        public UriBuilder setHost(String val) {
            this.host = val;
            return this;
        }

        @Override
        public String getHost() {
            return this.host;
        }

        @Override
        public UriBuilder setPath(GString val) {
            this.path = val;
            return this;
        }

        @Override
        public GString getPath() {
            return this.path;
        }

        @Override
        public UriBuilder setQuery(Map<String, ?> val) {
            this.query.putAll(val);
            return this;
        }

        @Override
        public Map<String, ?> getQuery() {
            return this.query;
        }

        @Override
        public UriBuilder setFragment(String val) {
            this.fragment = val;
            return this;
        }

        @Override
        public String getFragment() {
            return this.fragment;
        }

        @Override
        public UriBuilder setUserInfo(String val) {
            this.userInfo = val;
            return this;
        }

        @Override
        public String getUserInfo() {
            return this.userInfo;
        }

        @Override
        public UriBuilder getParent() {
            return this.parent;
        }

        public ThreadSafe(UriBuilder parent) {
            this.parent = parent;
        }
    }

    private static final class Basic
    extends UriBuilder {
        private String scheme;
        private int port = -1;
        private String host;
        private GString path;
        private Map<String, Object> query = new LinkedHashMap<String, Object>(1);
        private String fragment;
        private String userInfo;
        private final UriBuilder parent;

        @Override
        public UriBuilder setScheme(String val) {
            this.scheme = val;
            return this;
        }

        @Override
        public String getScheme() {
            return this.scheme;
        }

        @Override
        public UriBuilder setPort(int val) {
            this.port = val;
            return this;
        }

        @Override
        public int getPort() {
            return this.port;
        }

        @Override
        public UriBuilder setHost(String val) {
            this.host = val;
            return this;
        }

        @Override
        public String getHost() {
            return this.host;
        }

        @Override
        public UriBuilder setPath(GString val) {
            this.path = val;
            return this;
        }

        @Override
        public GString getPath() {
            return this.path;
        }

        @Override
        public UriBuilder setQuery(Map<String, ?> val) {
            if (val != null) {
                this.query.putAll(val);
            }
            return this;
        }

        public Map<String, Object> getQuery() {
            return this.query;
        }

        @Override
        public UriBuilder setFragment(String val) {
            this.fragment = val;
            return this;
        }

        @Override
        public String getFragment() {
            return this.fragment;
        }

        @Override
        public UriBuilder setUserInfo(String val) {
            this.userInfo = val;
            return this;
        }

        @Override
        public String getUserInfo() {
            return this.userInfo;
        }

        @Override
        public UriBuilder getParent() {
            return this.parent;
        }

        public Basic(UriBuilder parent) {
            this.parent = parent;
        }
    }
}

