/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.language;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.builder.SimpleBuilder;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.spi.Metadata;
import org.apache.camel.util.ObjectHelper;

@Metadata(firstVersion="1.1.0", label="language,core,java", title="Simple")
@XmlRootElement(name="simple")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class SimpleExpression
extends ExpressionDefinition {
    @XmlAttribute(name="resultType")
    private String resultTypeName;
    @XmlTransient
    private Class<?> resultType;

    public SimpleExpression() {
    }

    public SimpleExpression(String expression) {
        super(expression);
    }

    public SimpleExpression(Expression expression) {
        super(expression);
    }

    @Override
    public String getLanguage() {
        return "simple";
    }

    public Class<?> getResultType() {
        return this.resultType;
    }

    public void setResultType(Class<?> resultType) {
        this.resultType = resultType;
    }

    public String getResultTypeName() {
        return this.resultTypeName;
    }

    public void setResultTypeName(String resultTypeName) {
        this.resultTypeName = resultTypeName;
    }

    @Override
    public Expression createExpression(CamelContext camelContext) {
        boolean isTrim;
        if (this.resultType == null && this.resultTypeName != null) {
            try {
                this.resultType = camelContext.getClassResolver().resolveMandatoryClass(this.resultTypeName);
            }
            catch (ClassNotFoundException e) {
                throw ObjectHelper.wrapRuntimeCamelException(e);
            }
        }
        String exp = this.getExpression();
        boolean bl = isTrim = this.getTrim() == null || this.getTrim() != false;
        if (exp != null && isTrim) {
            exp = exp.trim();
        }
        SimpleBuilder answer = new SimpleBuilder(exp);
        answer.setResultType(this.resultType);
        return answer;
    }

    @Override
    public Predicate createPredicate(CamelContext camelContext) {
        return (Predicate)((Object)this.createExpression(camelContext));
    }
}

