/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import org.apache.uima.cas.CASRuntimeException;
import org.apache.uima.cas.impl.FeatureImpl;
import org.apache.uima.cas.impl.TypeImpl;
import org.apache.uima.cas.impl.TypeSystemImpl;
import org.apache.uima.internal.util.Misc;

public class CasTypeSystemMapper {
    public final TypeSystemImpl tsSrc;
    public final WeakReference<TypeSystemImpl> tsTgt;
    private final List<TypeImpl> tSrc2Tgt = new ArrayList<TypeImpl>();
    private final List<TypeImpl> tTgt2Src = new ArrayList<TypeImpl>();
    private final FeatureImpl[][] fSrc2Tgt;
    private final FeatureImpl[][] fTgt2Src;
    private final boolean typeSystemsSame;

    public boolean isEqual() {
        return this.typeSystemsSame;
    }

    public CasTypeSystemMapper(TypeSystemImpl tsSrc, TypeSystemImpl tsTgt) {
        if (!tsSrc.isCommitted() || !tsTgt.isCommitted()) {
            throw new CASRuntimeException("TYPESYSTEMS_NOT_COMMITTED", new Object[0]);
        }
        this.tsSrc = tsSrc;
        this.tsTgt = new WeakReference<TypeSystemImpl>(tsTgt);
        boolean tss = true;
        if (tsSrc != tsTgt) {
            this.fSrc2Tgt = new FeatureImpl[tsSrc.getTypeArraySize()][];
            this.fTgt2Src = new FeatureImpl[tsTgt.getTypeArraySize()][];
            boolean b1 = this.addTypes(this.tSrc2Tgt, tsSrc, tsTgt);
            boolean b2 = this.addTypes(this.tTgt2Src, tsTgt, tsSrc);
            boolean b3 = this.addFeatures(this.fSrc2Tgt, tsSrc, tsTgt);
            boolean b4 = this.addFeatures(this.fTgt2Src, tsTgt, tsSrc);
            if (!(b1 && b2 && b3 && b4)) {
                tss = false;
            }
        } else {
            this.fSrc2Tgt = null;
            this.fTgt2Src = null;
        }
        this.typeSystemsSame = tss;
    }

    public TypeImpl mapTypeSrc2Tgt(TypeImpl srcType) {
        return this.tSrc2Tgt.isEmpty() ? srcType : this.tSrc2Tgt.get(srcType.getCode());
    }

    public TypeImpl mapTypeTgt2Src(TypeImpl tgtType) {
        return this.tTgt2Src.isEmpty() ? tgtType : this.tTgt2Src.get(tgtType.getCode());
    }

    public TypeImpl mapTypeCodeTgt2Src(int tgtTypeCode) {
        return this.tTgt2Src.isEmpty() ? this.tsSrc.getTypeForCode(tgtTypeCode) : this.tTgt2Src.get(tgtTypeCode);
    }

    public TypeImpl mapTypeCode2Other(TypeImpl type, boolean src2tgt) {
        return src2tgt ? this.mapTypeSrc2Tgt(type) : this.mapTypeTgt2Src(type);
    }

    public FeatureImpl getTgtFeature(TypeImpl srcType, FeatureImpl srcFeat) {
        return this.getToFeature(this.fSrc2Tgt, srcType, srcFeat);
    }

    public FeatureImpl getSrcFeature(TypeImpl tgtType, FeatureImpl tgtFeat) {
        return this.getToFeature(this.fTgt2Src, tgtType, tgtFeat);
    }

    public FeatureImpl[] getSrcFeatures(TypeImpl tgtType) {
        return this.fTgt2Src[tgtType.getCode()];
    }

    public FeatureImpl getToFeature(FeatureImpl[][] mapByTypeCode, TypeImpl fromType, FeatureImpl fromFeat) {
        if (mapByTypeCode == null) {
            return fromFeat;
        }
        FeatureImpl[] map = mapByTypeCode[fromType.getCode()];
        if (map == null) {
            return null;
        }
        int offset = fromFeat.getOffset();
        if (map.length <= offset) {
            return null;
        }
        return map[offset];
    }

    private boolean addTypes(List<TypeImpl> map, TypeSystemImpl tsSrc, TypeSystemImpl tsTgt) {
        boolean r = true;
        for (TypeImpl tSrc : tsSrc.getAllTypes()) {
            TypeImpl ti = tsTgt.getType(tSrc.getName());
            Misc.setWithExpand(map, tSrc.getCode(), ti);
            r &= null != ti;
        }
        return r;
    }

    private boolean addFeatures(FeatureImpl[][] map, TypeSystemImpl tsFrom, TypeSystemImpl tsTo) {
        boolean r = true;
        for (TypeImpl ti : tsFrom.getAllTypes()) {
            TypeImpl toTi = tsTo.getType(ti.getName());
            if (toTi == null) {
                r = false;
                continue;
            }
            FeatureImpl[] featureImplArray = new FeatureImpl[ti.getFeatureImpls().length];
            map[ti.getCode()] = featureImplArray;
            FeatureImpl[] map1 = featureImplArray;
            for (FeatureImpl fi : ti.getFeatureImpls()) {
                FeatureImpl toFi = toTi.getFeatureByBaseName(fi.getShortName());
                if (toFi == null) {
                    r = false;
                    continue;
                }
                map1[fi.getOffset()] = toFi;
                if (!r || fi.getRange().getName().equals(toFi.getRange().getName()) && fi.getOffset() == toFi.getOffset() && fi.isMultipleReferencesAllowed() == toFi.isMultipleReferencesAllowed()) continue;
                r = false;
            }
        }
        return r;
    }
}

