/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.fit.factory;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.uima.UIMAFramework;
import org.apache.uima.fit.internal.ClassLoaderUtils;
import org.apache.uima.fit.internal.MetaDataType;
import org.apache.uima.fit.internal.MetaDataUtil;
import org.apache.uima.fit.internal.ResourceManagerFactory;
import org.apache.uima.internal.util.ServiceLoaderUtil;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.metadata.Import;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.resource.metadata.impl.Import_impl;
import org.apache.uima.resource.metadata.impl.TypeSystemDescription_impl;
import org.apache.uima.spi.TypeSystemDescriptionProvider;
import org.apache.uima.spi.TypeSystemProvider;
import org.apache.uima.util.CasCreationUtils;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLInputSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TypeSystemDescriptionFactory {
    private static final Logger LOG = LoggerFactory.getLogger(TypeSystemDescriptionFactory.class);
    private static final Object SCAN_LOCK = new Object();
    private static final Object CREATE_LOCK = new Object();
    private static final TypeSystemDescription PLACEHOLDER = new TypeSystemDescription_impl();
    private static WeakHashMap<String, TypeSystemDescription> typeDescriptors = new WeakHashMap();
    private static WeakHashMap<ClassLoader, String[]> typeDescriptorLocationsByClassloader = new WeakHashMap();
    private static WeakHashMap<ClassLoader, TypeSystemDescription> typeDescriptorByClassloader = new WeakHashMap();

    private TypeSystemDescriptionFactory() {
    }

    public static TypeSystemDescription createTypeSystemDescription(String ... descriptorNames) {
        TypeSystemDescription_impl typeSystem = new TypeSystemDescription_impl();
        ArrayList<Import_impl> imports = new ArrayList<Import_impl>();
        for (String descriptorName : descriptorNames) {
            Import_impl imp = new Import_impl();
            imp.setName(descriptorName);
            imports.add(imp);
        }
        Import[] importArray = new Import[imports.size()];
        typeSystem.setImports(imports.toArray(importArray));
        return typeSystem;
    }

    public static TypeSystemDescription createTypeSystemDescriptionFromPath(String ... descriptorURIs) {
        TypeSystemDescription_impl typeSystem = new TypeSystemDescription_impl();
        ArrayList<Import_impl> imports = new ArrayList<Import_impl>();
        for (String descriptorURI : descriptorURIs) {
            Import_impl imp = new Import_impl();
            imp.setLocation(descriptorURI);
            imports.add(imp);
        }
        Import[] importArray = new Import[imports.size()];
        typeSystem.setImports(imports.toArray(importArray));
        return typeSystem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TypeSystemDescription createTypeSystemDescription() throws ResourceInitializationException {
        ClassLoader cl = ClassLoaderUtils.findClassloader();
        TypeSystemDescription tsd = typeDescriptorByClassloader.get(cl);
        if (tsd == null) {
            Object object = CREATE_LOCK;
            synchronized (object) {
                ResourceManager resMgr = ResourceManagerFactory.newResourceManager();
                ArrayList<TypeSystemDescription> tsdList = new ArrayList<TypeSystemDescription>();
                TypeSystemDescriptionFactory.loadTypeSystemDescriptionsFromScannedLocations(tsdList, resMgr);
                TypeSystemDescriptionFactory.loadTypeSystemDescriptionsFromSPIs(tsdList);
                LOG.trace("Merging type systems and resolving imports...");
                tsd = CasCreationUtils.mergeTypeSystems(tsdList, (ResourceManager)resMgr);
                typeDescriptorByClassloader.put(cl, tsd);
            }
        }
        return (TypeSystemDescription)tsd.clone();
    }

    static void loadTypeSystemDescriptionsFromScannedLocations(List<TypeSystemDescription> tsdList, ResourceManager aResMgr) throws ResourceInitializationException {
        for (String location : TypeSystemDescriptionFactory.scanTypeDescriptors()) {
            try {
                TypeSystemDescription description = typeDescriptors.get(location);
                if (description == PLACEHOLDER) {
                    description = UIMAFramework.getXMLParser().parseTypeSystemDescription(new XMLInputSource(location));
                    description.resolveImports(aResMgr);
                    typeDescriptors.put(location, description);
                }
                tsdList.add(description);
                LOG.debug("Detected type system at [{}]", (Object)location);
            }
            catch (IOException e) {
                throw new ResourceInitializationException((Throwable)e);
            }
            catch (InvalidXMLException e) {
                LOG.warn("[{}] is not a type file. Ignoring.", (Object)location, (Object)e);
            }
        }
    }

    static void loadTypeSystemDescriptionsFromSPIs(List<TypeSystemDescription> tsdList) {
        Set loaded = Collections.newSetFromMap(new IdentityHashMap());
        ServiceLoaderUtil.loadServicesSafely(TypeSystemDescriptionProvider.class).forEach(provider -> {
            for (TypeSystemDescription desc : provider.listTypeSystemDescriptions()) {
                loaded.add(desc);
                tsdList.add(desc);
                LOG.debug("Loaded legacy SPI-provided type system at [{}]", (Object)desc.getSourceUrlString());
            }
        });
        ServiceLoaderUtil.loadServicesSafely(TypeSystemProvider.class).forEach(provider -> {
            for (TypeSystemDescription desc : provider.listTypeSystemDescriptions()) {
                if (loaded.contains(desc)) continue;
                tsdList.add(desc);
                LOG.debug("Loaded SPI-provided type system at [{}]", (Object)desc.getSourceUrlString());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] scanTypeDescriptors() throws ResourceInitializationException {
        Object object = SCAN_LOCK;
        synchronized (object) {
            ClassLoader cl = ClassLoaderUtils.findClassloader();
            String[] typeDescriptorLocations = typeDescriptorLocationsByClassloader.get(cl);
            if (typeDescriptorLocations == null) {
                typeDescriptorLocations = MetaDataUtil.scanDescriptors(MetaDataType.TYPE_SYSTEM);
                TypeSystemDescriptionFactory.internTypeDescriptorLocations(typeDescriptorLocations);
                typeDescriptorLocationsByClassloader.put(cl, typeDescriptorLocations);
            }
            return typeDescriptorLocations;
        }
    }

    private static void internTypeDescriptorLocations(String[] typeDescriptorLocations) {
        HashMap<String, String> locationStrings = new HashMap<String, String>();
        typeDescriptors.keySet().stream().forEach(loc -> locationStrings.put((String)loc, (String)loc));
        for (int i = 0; i < typeDescriptorLocations.length; ++i) {
            String existingLocString = (String)locationStrings.get(typeDescriptorLocations[i]);
            if (existingLocString == null) {
                typeDescriptors.put(typeDescriptorLocations[i], PLACEHOLDER);
                locationStrings.put(typeDescriptorLocations[i], typeDescriptorLocations[i]);
                continue;
            }
            typeDescriptorLocations[i] = existingLocString;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void forceTypeDescriptorsScan() {
        Object object = SCAN_LOCK;
        synchronized (object) {
            typeDescriptorLocationsByClassloader.clear();
            typeDescriptorByClassloader.clear();
            typeDescriptors.clear();
        }
    }
}

