/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.util.Comparator;
import java.util.NoSuchElementException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.impl.LowLevelIndex;
import org.apache.uima.cas.impl.LowLevelIterator;
import org.apache.uima.jcas.cas.TOP;

class FsIterator_limited<T extends FeatureStructure>
implements LowLevelIterator<T> {
    private final LowLevelIterator<T> iterator;
    private final int limit;
    private int count = 0;
    private boolean limitReached = false;

    FsIterator_limited(FSIterator<T> iterator, int limit) {
        this.iterator = (LowLevelIterator)iterator;
        this.limit = limit;
        this.limitReached = limit <= this.count;
    }

    private void maybeMakeInvalid() {
        if (this.count < 0 || this.count == this.limit) {
            this.limitReached = true;
        }
    }

    @Override
    public T getNvc() {
        this.maybeMakeInvalid();
        if (this.limitReached) {
            throw new NoSuchElementException();
        }
        Object r = this.iterator.get();
        return r;
    }

    @Override
    public void moveToNextNvc() {
        this.maybeMakeInvalid();
        if (this.limitReached) {
            return;
        }
        this.iterator.moveToNext();
        ++this.count;
    }

    @Override
    public void moveToPreviousNvc() {
        --this.count;
        this.maybeMakeInvalid();
        if (this.limitReached) {
            return;
        }
        this.iterator.moveToPrevious();
    }

    @Override
    public void moveToFirstNoReinit() {
        this.iterator.moveToFirstNoReinit();
        this.count = 0;
        this.limitReached = this.limit <= this.count;
    }

    @Override
    public void moveToLastNoReinit() {
        if (this.count >= 0 && this.limitReached && this.iterator.isValid()) {
            this.iterator.moveToPrevious();
            --this.count;
        } else {
            this.moveToFirstNoReinit();
        }
        while (this.count < this.limit - 1 && this.iterator.isValid()) {
            this.iterator.moveToNextNvc();
            if (!this.iterator.isValid()) {
                this.iterator.moveToLastNoReinit();
                break;
            }
            ++this.count;
        }
        this.limitReached = this.limit <= this.count;
    }

    @Override
    public void moveToNoReinit(FeatureStructure fs) {
        if (!this.isValid()) {
            this.moveToFirstNoReinit();
        }
        Comparator<TOP> cmp = this.iterator.getComparator();
        boolean skippedMatch = false;
        boolean movedForward = false;
        while (this.isValid()) {
            Object current = this.get();
            int c = cmp.compare((TOP)current, (TOP)fs);
            if (c == 0) {
                if (movedForward) break;
                this.moveToPreviousNvc();
                skippedMatch = true;
                continue;
            }
            if (skippedMatch) break;
            if (c < 0) {
                this.moveToNextNvc();
                movedForward = true;
                continue;
            }
            if (c <= 0) continue;
            this.moveToPreviousNvc();
        }
        if (skippedMatch) {
            if (!this.isValid()) {
                this.moveToFirstNoReinit();
            } else {
                this.moveToNextNvc();
            }
        }
    }

    @Override
    public FSIterator<T> copy() {
        FsIterator_limited copy = new FsIterator_limited(this.iterator.copy(), this.limit);
        copy.count = this.count;
        copy.limitReached = this.limitReached;
        return copy;
    }

    @Override
    public boolean isValid() {
        this.maybeMakeInvalid();
        return !this.limitReached && this.iterator.isValid();
    }

    @Override
    public int ll_indexSizeMaybeNotCurrent() {
        return this.iterator.ll_indexSizeMaybeNotCurrent();
    }

    @Override
    public int ll_maxAnnotSpan() {
        return this.iterator.ll_maxAnnotSpan();
    }

    @Override
    public LowLevelIndex<T> ll_getIndex() {
        return this.iterator.ll_getIndex();
    }

    @Override
    public boolean isIndexesHaveBeenUpdated() {
        return this.iterator.isIndexesHaveBeenUpdated();
    }

    @Override
    public boolean maybeReinitIterator() {
        return this.iterator.maybeReinitIterator();
    }

    @Override
    public Comparator<TOP> getComparator() {
        return this.iterator.getComparator();
    }

    @Override
    public int size() {
        return Math.min(this.limit, this.iterator.size());
    }
}

