/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.internal.util;

import java.util.Arrays;
import org.apache.uima.util.impl.Constants;

public class TextStringTokenizer {
    public static final int EOS = 0;
    public static final int SEP = 1;
    public static final int WSP = 2;
    public static final int WCH = 3;
    private final String text;
    private final int end;
    private int pos;
    private char[] eosDels = Constants.EMPTY_CHAR_ARRAY;
    private char[] separators = Constants.EMPTY_CHAR_ARRAY;
    private char[] whitespace = Constants.EMPTY_CHAR_ARRAY;
    private char[] wordChars = Constants.EMPTY_CHAR_ARRAY;
    private int nextTokenStart;
    private int nextTokenEnd;
    private int nextTokenType;
    private boolean nextComputed = false;
    private boolean showWhitespace = true;
    private boolean showSeparators = true;

    public TextStringTokenizer(String string) {
        this.text = string;
        this.pos = 0;
        this.end = string.length() - 1;
        this.setToNext();
    }

    public void setShowWhitespace(boolean b) {
        this.showWhitespace = b;
    }

    public void setShowSeparators(boolean b) {
        this.showSeparators = b;
    }

    public void setEndOfSentenceChars(String chars) {
        if (chars == null) {
            TextStringTokenizer.makeSortedList("");
        } else {
            this.eosDels = TextStringTokenizer.makeSortedList(chars);
        }
    }

    public void addToEndOfSentenceChars(String chars) {
        if (chars == null) {
            return;
        }
        this.eosDels = TextStringTokenizer.addToSortedList(chars, this.eosDels);
    }

    public void setSeparators(String chars) {
        if (chars == null) {
            chars = "";
        }
        this.separators = TextStringTokenizer.makeSortedList(chars);
    }

    public void addSeparators(String chars) {
        if (chars == null) {
            return;
        }
        this.separators = TextStringTokenizer.addToSortedList(chars, this.separators);
    }

    public void setWhitespaceChars(String chars) {
        if (chars == null) {
            chars = "";
        }
        this.whitespace = TextStringTokenizer.makeSortedList(chars);
    }

    public void addWhitespaceChars(String chars) {
        if (chars == null) {
            return;
        }
        this.whitespace = TextStringTokenizer.addToSortedList(chars, this.whitespace);
    }

    public void setWordChars(String chars) {
        if (chars == null) {
            chars = "";
        }
        this.wordChars = TextStringTokenizer.makeSortedList(chars);
    }

    public void addWordChars(String chars) {
        if (chars == null) {
            return;
        }
        this.wordChars = TextStringTokenizer.addToSortedList(chars, this.wordChars);
    }

    public int getTokenType() {
        if (this.nextComputed) {
            return this.nextTokenType;
        }
        return -1;
    }

    public boolean isValid() {
        return this.nextComputed;
    }

    public void setToFirst() {
        this.pos = 0;
        this.setToNext();
    }

    public String getToken() {
        if (!this.nextComputed) {
            return null;
        }
        return this.text.substring(this.nextTokenStart, this.nextTokenEnd);
    }

    public int getTokenStart() {
        if (!this.nextComputed) {
            return -1;
        }
        return this.nextTokenStart;
    }

    public int getTokenEnd() {
        if (!this.nextComputed) {
            return -1;
        }
        return this.nextTokenEnd;
    }

    public void setToNext() {
        if (this.pos > this.end) {
            this.nextComputed = false;
            return;
        }
        this.nextTokenStart = this.pos;
        int charType = this.getCharType(this.text.charAt(this.pos));
        block0 : switch (charType) {
            case 0: {
                ++this.pos;
                this.nextTokenType = 0;
                break;
            }
            case 1: {
                ++this.pos;
                if (!this.showSeparators) {
                    this.setToNext();
                    return;
                }
                this.nextTokenType = 1;
                break;
            }
            case 2: {
                ++this.pos;
                while (this.pos <= this.end && this.getCharType(this.text.charAt(this.pos)) == 2) {
                    ++this.pos;
                }
                if (!this.showWhitespace) {
                    this.setToNext();
                    return;
                }
                this.nextTokenType = 2;
                break;
            }
            case 3: {
                ++this.pos;
                this.nextTokenType = 3;
                if (this.pos > this.end) break;
                charType = this.getCharType(this.text.charAt(this.pos));
                while (this.pos < this.end && (charType == 3 || charType == 0)) {
                    ++this.pos;
                    if (charType == 0) {
                        if (this.pos >= this.end) {
                            --this.pos;
                            break block0;
                        }
                        charType = this.getCharType(this.text.charAt(this.pos));
                        if (charType != 3) {
                            --this.pos;
                            break block0;
                        }
                    }
                    charType = this.getCharType(this.text.charAt(this.pos));
                }
                break;
            }
            default: {
                return;
            }
        }
        this.nextTokenEnd = this.pos;
        this.nextComputed = true;
    }

    public int getCharType(char c) {
        if (Arrays.binarySearch(this.eosDels, c) >= 0) {
            return 0;
        }
        if (Arrays.binarySearch(this.separators, c) >= 0) {
            return 1;
        }
        if (Arrays.binarySearch(this.whitespace, c) >= 0) {
            return 2;
        }
        if (Arrays.binarySearch(this.wordChars, c) >= 0) {
            return 3;
        }
        if (Character.isWhitespace(c)) {
            return 2;
        }
        return 3;
    }

    private static final char[] addToSortedList(String s, char[] list) {
        char[] newList = new char[list.length + s.length()];
        System.arraycopy(list, 0, newList, 0, list.length);
        s.getChars(0, s.length(), newList, list.length);
        Arrays.sort(newList);
        return newList;
    }

    private static final char[] makeSortedList(String s) {
        char[] newList = new char[s.length()];
        s.getChars(0, s.length(), newList, 0);
        Arrays.sort(newList);
        return newList;
    }
}

