/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.taeconfigurator.editors.ui;

import org.apache.uima.UIMAFramework;
import org.apache.uima.analysis_engine.metadata.FixedFlow;
import org.apache.uima.analysis_engine.metadata.FlowConstraints;
import org.apache.uima.resource.ExternalResourceDependency;
import org.apache.uima.resource.ExternalResourceDescription;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.metadata.ConfigurationParameter;
import org.apache.uima.resource.metadata.ConfigurationParameterSettings;
import org.apache.uima.resource.metadata.ExternalResourceBinding;
import org.apache.uima.resource.metadata.FsIndexDescription;
import org.apache.uima.resource.metadata.ResourceManagerConfiguration;
import org.apache.uima.taeconfigurator.InternalErrorCDE;
import org.apache.uima.taeconfigurator.editors.MultiPageEditor;
import org.apache.uima.taeconfigurator.editors.ui.AbstractSection;
import org.apache.uima.taeconfigurator.editors.ui.HeaderPageWithSash;
import org.apache.uima.taeconfigurator.editors.ui.PrimitiveSection;
import org.apache.uima.taeconfigurator.editors.ui.Utility;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.forms.IManagedForm;

public class GeneralSection
extends AbstractSection {
    private Button cppButton;
    private Button javaButton;
    private Button primitiveButton;
    private Button aggregateButton;

    @Override
    public void enable() {
    }

    public GeneralSection(MultiPageEditor aEditor, Composite parent) {
        super(aEditor, parent, "Implementation Details", null);
    }

    @Override
    public void initialize(IManagedForm form) {
        super.initialize(form);
        ((GridData)this.getSection().getLayoutData()).grabExcessVerticalSpace = false;
        Composite sectionClient = this.new2ColumnComposite((Composite)this.getSection());
        ((GridData)sectionClient.getLayoutData()).grabExcessVerticalSpace = false;
        if (this.isAeDescriptor() || this.isCasConsumerDescriptor()) {
            this.toolkit.createLabel(sectionClient, "Implementation Language").setToolTipText("Choose the implementation language here.");
            Composite buttons = this.new2ColumnComposite(sectionClient);
            this.cppButton = this.newRadioButton(buttons, "C/C++", "C/C++", false);
            this.javaButton = this.newRadioButton(buttons, "Java", "Java", true);
            this.toolkit.createLabel(sectionClient, "Engine Type").setToolTipText("Choose the type of the engine here.");
            buttons = this.new2ColumnComposite(sectionClient);
            this.primitiveButton = this.newRadioButton(buttons, "Primitive", "", true);
            this.aggregateButton = this.newRadioButton(buttons, "Aggregate", "", false);
        }
    }

    public void refresh() {
        super.refresh();
        boolean isPrimitive = this.isPrimitive();
        if (this.isAeDescriptor() || this.isCasConsumerDescriptor()) {
            this.primitiveButton.setSelection(isPrimitive);
            this.aggregateButton.setSelection(!isPrimitive);
            String implType = this.editor.getAeDescription().getFrameworkImplementation();
            this.cppButton.setSelection("org.apache.uima.cpp".equals(implType));
            this.javaButton.setSelection("org.apache.uima.java".equals(implType));
        }
    }

    public void handleEvent(Event event) {
        PrimitiveSection s;
        if (event.widget == this.primitiveButton || event.widget == this.aggregateButton) {
            boolean isPrimitive = this.primitiveButton.getSelection();
            if (event.widget == this.primitiveButton && !isPrimitive) {
                return;
            }
            if (event.widget == this.aggregateButton && isPrimitive) {
                return;
            }
            if (isPrimitive && this.isPrimitive()) {
                return;
            }
            if (!isPrimitive && this.isAggregate()) {
                return;
            }
            if (isPrimitive) {
                if (1 == Utility.popOkCancel("Switching from Aggregate", "This action will clear the capabilities, reset the delegates, reset the flow, reset the parameters, reset any resource information and start with an empty type system.  Are you sure?", 4)) {
                    this.aggregateButton.setSelection(true);
                    this.primitiveButton.setSelection(false);
                    return;
                }
                this.editor.getAeDescription().setAnnotatorImplementationName("");
            } else {
                if (1 == Utility.popOkCancel("Switching from Primitive AE", "This action will clear the capabilities, reset the delegates, reset the parameters, reset any resource information and reset the type system.  Are you sure?", 4)) {
                    this.primitiveButton.setSelection(true);
                    this.aggregateButton.setSelection(false);
                    return;
                }
                this.editor.getAeDescription().setAnnotatorImplementationName(null);
            }
            this.editor.getAeDescription().setPrimitive(isPrimitive);
            this.commonResets();
            try {
                this.editor.setAeDescription(this.editor.getAeDescription());
            }
            catch (ResourceInitializationException e) {
                throw new InternalErrorCDE("invalid state", e);
            }
            this.javaButton.setEnabled(isPrimitive);
            this.cppButton.setEnabled(isPrimitive);
            HeaderPageWithSash page = this.editor.getAggregatePage();
            if (null != page) {
                page.markStale();
            }
            if (null != (page = this.editor.getParameterPage())) {
                page.markStale();
            }
            if (null != (page = this.editor.getSettingsPage())) {
                page.markStale();
            }
            if (null != (page = this.editor.getTypePage())) {
                this.markRestOfPageStale(page.getManagedForm(), null);
            }
            if (null != (page = this.editor.getCapabilityPage())) {
                page.markStale();
            }
            if (null != (page = this.editor.getIndexesPage())) {
                page.markStale();
            }
            if (null != (page = this.editor.getResourcesPage())) {
                page.markStale();
            }
        }
        if (event.widget == this.javaButton || event.widget == this.cppButton) {
            this.valueChanged = false;
            if (this.cppButton.getSelection()) {
                this.editor.getAeDescription().setFrameworkImplementation(this.setValueChanged("org.apache.uima.cpp", this.editor.getAeDescription().getFrameworkImplementation()));
            } else {
                this.editor.getAeDescription().setFrameworkImplementation(this.setValueChanged("org.apache.uima.java", this.editor.getAeDescription().getFrameworkImplementation()));
            }
            if (!this.valueChanged) {
                return;
            }
        }
        if (null != (s = this.editor.getOverviewPage().getPrimitiveSection())) {
            s.refresh();
            s.getSection().getClient().redraw();
        }
        this.setFileDirty();
    }

    private void commonResets() {
        this.getDelegateAnalysisEngineSpecifiersWithImports().clear();
        this.editor.getResolvedDelegates().clear();
        if (this.isAggregate()) {
            FixedFlow flowConstraints = UIMAFramework.getResourceSpecifierFactory().createFixedFlow();
            flowConstraints.setAttributeValue("fixedFlow", (Object)stringArray0);
            this.getAnalysisEngineMetaData().setFlowConstraints((FlowConstraints)flowConstraints);
        } else {
            this.getAnalysisEngineMetaData().setFlowConstraints(null);
        }
        this.getAnalysisEngineMetaData().setCapabilities(capabilityArray0);
        this.addCapabilitySet();
        this.getConfigurationParameterDeclarations().setConfigurationParameters(new ConfigurationParameter[0]);
        this.getConfigurationParameterDeclarations().setConfigurationGroups(AbstractSection.configurationGroupArray0);
        this.getConfigurationParameterDeclarations().setCommonParameters(new ConfigurationParameter[0]);
        this.getConfigurationParameterDeclarations().setDefaultGroupName("");
        this.getConfigurationParameterDeclarations().setSearchStrategy("");
        ConfigurationParameterSettings configParmSettings = UIMAFramework.getResourceSpecifierFactory().createConfigurationParameterSettings();
        this.getAnalysisEngineMetaData().setConfigurationParameterSettings(configParmSettings);
        this.getAnalysisEngineMetaData().setTypeSystem(null);
        this.editor.getAeDescription().setExternalResourceDependencies(new ExternalResourceDependency[0]);
        ResourceManagerConfiguration rmc = this.editor.getAeDescription().getResourceManagerConfiguration();
        if (null != rmc) {
            rmc.setExternalResourceBindings(new ExternalResourceBinding[0]);
            rmc.setExternalResources(new ExternalResourceDescription[0]);
        }
        this.getAnalysisEngineMetaData().setFsIndexCollection(null);
        this.getAnalysisEngineMetaData().setFsIndexes(new FsIndexDescription[0]);
        this.getAnalysisEngineMetaData().setTypePriorities(null);
    }
}

