/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.uima.ducc.transport.configuration.jp;


import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

/**
 * Custom ThreadFactory for use in the TaskExecutor. The TaskExecutor is plugged in by Spring from
 * spring xml file generated by dd2spring. The TaskExecutor is only defined for PrimitiveControllers
 * and its main purpose is to provide thread pooling and management. Each new thread produced by
 * this ThreadFactory is used to initialize a dedicated AE instance in the PrimitiveController.
 * 
 * 
 */
public class UimaServiceThreadFactory implements ThreadFactory {
  
  private static final String THREAD_POOL = "[UimaServiceThreadPool ";

 
  private ThreadGroup theThreadGroup;

  private String threadNamePrefix=null;
  
  private boolean isDaemon=false;
  
  public static AtomicInteger poolIdGenerator = new AtomicInteger();
  
  private final int poolId = poolIdGenerator.incrementAndGet();
  
  public UimaServiceThreadFactory(ThreadGroup tGroup) { 
	  
    theThreadGroup = tGroup;
    }
  
  public void setThreadNamePrefix(String prefix) {
    threadNamePrefix = prefix;
  }
  public void setThreadGroup( ThreadGroup tGroup) {
    theThreadGroup = tGroup;
  }
  public void setDaemon(boolean daemon) {
 //   isDaemon = daemon;
  }
  public void stop() {
  }
  
  /**
   * Creates a new thread, initializes instance of AE via a call on a given PrimitiveController.
   * Once the thread finishes initializing AE instance in the controller, it calls run() on a given
   * Runnable. This Runnable is a Worker instance managed by the TaskExecutor. When the thread calls
   * run() on the Runnable it blocks until the Worker releases it.
   */
  public Thread newThread(final Runnable r) {
    Thread newThread = null;
    try {
      newThread = new Thread(theThreadGroup, new Runnable() {
        public void run() {
          if ( threadNamePrefix == null ) {
               threadNamePrefix = THREAD_POOL+poolId+"] " + " Process Thread";
          } 
          Thread.currentThread().setName( threadNamePrefix +" - "                 
                          + Thread.currentThread().getId());
          try {

        	  // Call given Worker (Runnable) run() method and block. This call blocks until the
            // TaskExecutor is terminated.
            r.run();
          } catch (Throwable e) {
            return;
          } finally {
          }
        
        }
      });
    } catch (Exception e) {
    }
    if ( newThread != null ) {
      newThread.setDaemon(isDaemon);
    }
    return newThread;
  }
}
