/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.expression.number;

import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.block.RutaBlock;
import org.apache.uima.ruta.expression.number.AbstractNumberExpression;
import org.apache.uima.ruta.rule.MatchContext;

public class NumberVariableExpression
extends AbstractNumberExpression {
    private final String var;

    public NumberVariableExpression(String var) {
        this.var = var;
    }

    @Override
    public double getDoubleValue(MatchContext context, RutaStream stream) {
        RutaBlock parent = context.getParent();
        Object value = parent.getEnvironment().getVariableValue(this.getVar(), stream);
        double variableValue = 0.0;
        if (value instanceof Number) {
            variableValue = ((Number)value).doubleValue();
        }
        return variableValue;
    }

    @Override
    public float getFloatValue(MatchContext context, RutaStream stream) {
        RutaBlock parent = context.getParent();
        Object value = parent.getEnvironment().getVariableValue(this.getVar(), stream);
        float variableValue = 0.0f;
        if (value instanceof Number) {
            variableValue = ((Number)value).floatValue();
        }
        return variableValue;
    }

    @Override
    public int getIntegerValue(MatchContext context, RutaStream stream) {
        RutaBlock parent = context.getParent();
        Object value = parent.getEnvironment().getVariableValue(this.getVar(), stream);
        int variableValue = 0;
        if (value instanceof Number) {
            variableValue = ((Number)value).intValue();
        }
        return variableValue;
    }

    @Override
    public String getStringValue(MatchContext context, RutaStream stream) {
        RutaBlock parent = context.getParent();
        Class<?> variableType = parent.getEnvironment().getVariableType(this.getVar());
        if (variableType.equals(Integer.class)) {
            return "" + this.getIntegerValue(context, stream);
        }
        return "" + this.getDoubleValue(context, stream);
    }

    public String getVar() {
        return this.var;
    }
}

