/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.expression;

import java.util.List;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.expression.IRutaExpression;
import org.apache.uima.ruta.expression.RutaExpression;
import org.apache.uima.ruta.expression.number.INumberExpression;
import org.apache.uima.ruta.expression.string.IStringExpression;
import org.apache.uima.ruta.rule.MatchContext;

public class GenericComposedExpression
extends RutaExpression
implements INumberExpression {
    private final List<IRutaExpression> expressions;

    public GenericComposedExpression(List<IRutaExpression> expressions) {
        this.expressions = expressions;
    }

    @Override
    public String getStringValue(MatchContext context, RutaStream stream) {
        if (this.expressions == null) {
            return null;
        }
        if (this.expressions.size() == 1) {
            IRutaExpression first = this.expressions.get(0);
            if (first instanceof IStringExpression) {
                return ((IStringExpression)first).getStringValue(context, stream);
            }
            return null;
        }
        StringBuilder result = new StringBuilder();
        for (IRutaExpression each : this.expressions) {
            if (!(each instanceof IStringExpression)) continue;
            result.append(((IStringExpression)each).getStringValue(context, stream));
        }
        return result.toString();
    }

    @Override
    public int getIntegerValue(MatchContext context, RutaStream stream) {
        return (int)this.getDoubleValue(context, stream);
    }

    @Override
    public double getDoubleValue(MatchContext context, RutaStream stream) {
        double result = 0.0;
        for (IRutaExpression each : this.expressions) {
            if (!(each instanceof INumberExpression)) continue;
            result += ((INumberExpression)each).getDoubleValue(context, stream);
        }
        return result;
    }

    @Override
    public float getFloatValue(MatchContext context, RutaStream stream) {
        return (float)this.getDoubleValue(context, stream);
    }

    public List<IRutaExpression> getExpressions() {
        return this.expressions;
    }
}

