/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.engine;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.uima.UIMAFramework;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.SerialFormat;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.fit.factory.TypeSystemDescriptionFactory;
import org.apache.uima.fit.util.CasUtil;
import org.apache.uima.resource.ResourceConfigurationException;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.metadata.TypeDescription;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.ruta.engine.RutaEngine;
import org.apache.uima.ruta.seed.DefaultSeeder;
import org.apache.uima.util.CasCreationUtils;
import org.apache.uima.util.CasIOUtils;
import org.apache.uima.util.FileUtils;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLInputSource;
import org.xml.sax.SAXException;

public class RutaTestUtils {
    public static final boolean DEBUG_MODE = RutaTestUtils.isDebugging();
    public static final String TYPE = "org.apache.uima.T";

    private static boolean isDebugging() {
        Pattern debugPattern = Pattern.compile("-Xdebug|jdwp");
        for (String arg : ManagementFactory.getRuntimeMXBean().getInputArguments()) {
            if (!debugPattern.matcher(arg).find()) continue;
            return true;
        }
        return false;
    }

    public static CAS process(String ruleFileName, String textFileName, int amount) throws URISyntaxException, IOException, InvalidXMLException, ResourceInitializationException, AnalysisEngineProcessException, ResourceConfigurationException {
        return RutaTestUtils.process(ruleFileName, textFileName, amount, false, false, null, null, null, null);
    }

    public static CAS process(String ruleFileName, String textFileName, Map<String, Object> parameters, int amount) throws URISyntaxException, IOException, InvalidXMLException, ResourceInitializationException, AnalysisEngineProcessException, ResourceConfigurationException {
        return RutaTestUtils.process(ruleFileName, textFileName, parameters, amount, null, null, null, null);
    }

    public static CAS process(String ruleFileName, String textFileName, int amount, boolean dynamicAnchoring, boolean simpleGreedyForComposed, Map<String, String> complexTypes, String resourceDirName) throws URISyntaxException, IOException, InvalidXMLException, ResourceInitializationException, AnalysisEngineProcessException, ResourceConfigurationException {
        return RutaTestUtils.process(ruleFileName, textFileName, amount, dynamicAnchoring, simpleGreedyForComposed, complexTypes, null, resourceDirName, null);
    }

    public static CAS process(String ruleFileName, String textFileName, int amount, boolean dynamicAnchoring, boolean simpleGreedyForComposed, Map<String, String> complexTypes, Map<String, List<TestFeature>> features, String resourceDirName) throws URISyntaxException, IOException, InvalidXMLException, ResourceInitializationException, AnalysisEngineProcessException, ResourceConfigurationException {
        return RutaTestUtils.process(ruleFileName, textFileName, amount, dynamicAnchoring, simpleGreedyForComposed, complexTypes, features, resourceDirName, null);
    }

    public static CAS process(String ruleFileName, String textFileName, int amount, boolean dynamicAnchoring, boolean simpleGreedyForComposed, Map<String, String> complexTypes, Map<String, List<TestFeature>> features, String resourceDirName, CAS cas) throws URISyntaxException, IOException, InvalidXMLException, ResourceInitializationException, AnalysisEngineProcessException, ResourceConfigurationException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("dynamicAnchoring", dynamicAnchoring);
        parameters.put("simpleGreedyForComposed", simpleGreedyForComposed);
        return RutaTestUtils.process(ruleFileName, textFileName, parameters, amount, complexTypes, features, resourceDirName, cas);
    }

    public static CAS process(String ruleFileName, String textFileName, Map<String, Object> parameters, int amount, Map<String, String> complexTypes, Map<String, List<TestFeature>> features, String resourceDirName, CAS cas) throws URISyntaxException, IOException, InvalidXMLException, ResourceInitializationException, AnalysisEngineProcessException, ResourceConfigurationException {
        URL url;
        URL ruleURL = RutaTestUtils.class.getClassLoader().getResource(ruleFileName);
        File ruleFile = new File(ruleURL.toURI());
        URL textURL = RutaTestUtils.class.getClassLoader().getResource(textFileName);
        File textFile = new File(textURL.toURI());
        File resourceFile = null;
        if (resourceDirName != null) {
            URL resourceURL = RutaTestUtils.class.getClassLoader().getResource(resourceDirName);
            resourceFile = new File(resourceURL.toURI());
        }
        if ((url = RutaEngine.class.getClassLoader().getResource("BasicEngine.xml")) == null) {
            url = RutaTestUtils.class.getClassLoader().getResource("org/apache/uima/ruta/TestEngine.xml");
        }
        if (url == null) {
            url = RutaTestUtils.class.getResource("/org/apache/uima/ruta/engine/BasicEngine.xml");
        }
        XMLInputSource in = new XMLInputSource(url);
        ResourceSpecifier specifier = UIMAFramework.getXMLParser().parseResourceSpecifier(in);
        AnalysisEngineDescription aed = (AnalysisEngineDescription)specifier;
        TypeSystemDescription basicTypeSystem = aed.getAnalysisEngineMetaData().getTypeSystem();
        RutaTestUtils.addTestTypes(basicTypeSystem);
        RutaTestUtils.addAdditionalTypes(complexTypes, features, basicTypeSystem);
        ArrayList<TypeSystemDescription> tsds = new ArrayList<TypeSystemDescription>();
        tsds.add(basicTypeSystem);
        TypeSystemDescription mergeTypeSystems = CasCreationUtils.mergeTypeSystems(tsds);
        aed.getAnalysisEngineMetaData().setTypeSystem(mergeTypeSystems);
        AnalysisEngine ae = UIMAFramework.produceAnalysisEngine((ResourceSpecifier)specifier);
        ae.setConfigParameterValue("scriptPaths", (Object)new String[]{ruleFile.getParentFile().getPath()});
        String name = ruleFile.getName();
        if (name.endsWith(".ruta")) {
            name = name.substring(0, name.length() - 5);
        }
        ae.setConfigParameterValue("dictRemoveWS", (Object)false);
        for (Map.Entry<String, Object> parameter : parameters.entrySet()) {
            ae.setConfigParameterValue(parameter.getKey(), parameter.getValue());
        }
        ae.setConfigParameterValue("mainScript", (Object)name);
        if (resourceFile != null) {
            ae.setConfigParameterValue("resourcePaths", (Object)new String[]{resourceFile.getPath()});
        }
        ae.reconfigure();
        if (cas == null) {
            cas = ae.newCAS();
            cas.setDocumentText(FileUtils.file2String((File)textFile, (String)"UTF-8"));
        }
        ae.process(cas);
        ae.destroy();
        return cas;
    }

    public static Type getTestType(CAS cas, int i) {
        if (cas == null) {
            return null;
        }
        return cas.getTypeSystem().getType(TYPE + i);
    }

    public static CAS getCAS(String document) throws ResourceInitializationException, IOException, InvalidXMLException, SAXException {
        return RutaTestUtils.getCAS(document, null, null);
    }

    public static CAS getCAS(String document, Map<String, String> complexTypes, Map<String, List<TestFeature>> features) throws ResourceInitializationException, IOException, InvalidXMLException, SAXException {
        return RutaTestUtils.getCAS(document, complexTypes, features, false);
    }

    public static CAS getCAS(String document, Map<String, String> complexTypes, Map<String, List<TestFeature>> features, boolean storeTypeSystem) throws ResourceInitializationException, IOException, InvalidXMLException, SAXException {
        URL url = RutaEngine.class.getClassLoader().getResource("BasicEngine.xml");
        if (url == null) {
            url = RutaTestUtils.class.getClassLoader().getResource("org/apache/uima/ruta/BasicEngine.xml");
        }
        if (url == null) {
            url = RutaTestUtils.class.getResource("BasicEngine.xml");
        }
        XMLInputSource in = new XMLInputSource(url);
        ResourceSpecifier specifier = UIMAFramework.getXMLParser().parseResourceSpecifier(in);
        AnalysisEngineDescription aed = (AnalysisEngineDescription)specifier;
        TypeSystemDescription basicTypeSystem = aed.getAnalysisEngineMetaData().getTypeSystem();
        RutaTestUtils.addTestTypes(basicTypeSystem);
        RutaTestUtils.addAdditionalTypes(complexTypes, features, basicTypeSystem);
        ArrayList<TypeSystemDescription> tsds = new ArrayList<TypeSystemDescription>();
        tsds.add(basicTypeSystem);
        TypeSystemDescription mergeTypeSystems = CasCreationUtils.mergeTypeSystems(tsds);
        if (storeTypeSystem) {
            try (FileOutputStream os = new FileOutputStream("TypeSystem.xml");){
                mergeTypeSystems.toXML((OutputStream)os);
            }
        }
        aed.getAnalysisEngineMetaData().setTypeSystem(mergeTypeSystems);
        AnalysisEngine ae = UIMAFramework.produceAnalysisEngine((ResourceSpecifier)specifier);
        CAS cas = ae.newCAS();
        cas.setDocumentText(document);
        return cas;
    }

    public static void addTestTypes(TypeSystemDescription typeSystemDescription) {
        for (int i = 1; i <= 50; ++i) {
            typeSystemDescription.addType(TYPE + i, "Type for Testing", "uima.tcas.Annotation");
        }
    }

    private static void addAdditionalTypes(Map<String, String> complexTypes, Map<String, List<TestFeature>> features, TypeSystemDescription typeSystemDescription) {
        if (complexTypes != null) {
            Set<Map.Entry<String, String>> entrySet = complexTypes.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                String name = entry.getKey();
                TypeDescription addType = typeSystemDescription.addType(name, "Type for Testing", entry.getValue());
                if (features == null) continue;
                List<TestFeature> list = features.get(name);
                for (TestFeature f : list) {
                    addType.addFeature(f.name, f.description, f.range);
                }
            }
        }
    }

    public static void printAnnotations(CAS cas, int typeId) {
        Type t = RutaTestUtils.getTestType(cas, typeId);
        AnnotationIndex ai = cas.getAnnotationIndex(t);
        for (AnnotationFS annotationFS : ai) {
            System.out.println(annotationFS.getCoveredText());
        }
    }

    public static void assertAnnotationsEquals(CAS cas, int typeId, int expectedCnt, String ... expecteds) {
        Type t = RutaTestUtils.getTestType(cas, typeId);
        Collection select = CasUtil.select((CAS)cas, (Type)t);
        if (select.size() != expectedCnt) {
            throw new RuntimeException("size of expected annotations (" + expectedCnt + ") does not match with actual size (" + select.size() + ").");
        }
        if (expecteds.length > 0) {
            Iterator iterator = select.iterator();
            for (String expected : expecteds) {
                String actual = ((AnnotationFS)iterator.next()).getCoveredText();
                if (actual.equals(expected)) continue;
                throw new RuntimeException("expected text (" + expected + ") does not match with actual (" + actual + ").");
            }
        }
    }

    public static CAS processTestScript(Class<?> testClass) {
        String name = testClass.getSimpleName();
        String namespace = testClass.getPackage().getName().replaceAll("\\.", "/");
        CAS cas = null;
        try {
            cas = RutaTestUtils.process(namespace + "/" + name + ".ruta", namespace + "/" + name + ".txt", 50);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return cas;
    }

    public static CAS processTestScriptWithDefaultSeeder(Class<?> testClass) throws Exception {
        String name = testClass.getSimpleName();
        String namespace = testClass.getPackage().getName().replaceAll("\\.", "/");
        String scriptPath = namespace + "/" + name + ".ruta";
        String textPath = namespace + "/" + name + ".txt";
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("seeders", new String[]{DefaultSeeder.class.getName()});
        return RutaTestUtils.process(scriptPath, textPath, params, 50);
    }

    public static void storeCas(CAS cas, String name) {
        File file = new File("input/" + name + ".xmi");
        file.getParentFile().mkdirs();
        try (FileOutputStream fos = new FileOutputStream(file);){
            CasIOUtils.save((CAS)cas, (OutputStream)fos, (SerialFormat)SerialFormat.XMI);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static void storeTypeSystem() {
        RutaTestUtils.storeTypeSystem(Collections.emptyMap(), Collections.emptyMap());
    }

    public static void storeTypeSystem(Map<String, String> complexTypes, Map<String, List<TestFeature>> features) {
        File tsFile = new File("TypeSystem.xml");
        try {
            TypeSystemDescription typeSystemDescription = TypeSystemDescriptionFactory.createTypeSystemDescription();
            RutaTestUtils.addTestTypes(typeSystemDescription);
            RutaTestUtils.addAdditionalTypes(complexTypes, features, typeSystemDescription);
            try (FileOutputStream os = new FileOutputStream(tsFile);){
                typeSystemDescription.toXML((OutputStream)os);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static Map<String, Object> getDebugParams() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("debug", true);
        params.put("debugWithMatches", true);
        params.put("createdBy", true);
        return params;
    }

    public static class TestFeature {
        public String name;
        public String description;
        public String range;

        public TestFeature(String name, String description, String range) {
            this.name = name;
            this.description = description;
            this.range = range;
        }
    }
}

