/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.expression.number;

import java.util.Collection;
import java.util.List;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.expression.feature.FeatureExpression;
import org.apache.uima.ruta.expression.feature.LazyFeature;
import org.apache.uima.ruta.expression.number.AbstractNumberExpression;
import org.apache.uima.ruta.rule.MatchContext;

public class NumberFeatureExpression
extends AbstractNumberExpression {
    private FeatureExpression fe;

    public NumberFeatureExpression(FeatureExpression fe) {
        this.fe = fe;
    }

    @Override
    public int getIntegerValue(MatchContext context, RutaStream stream) {
        Number v = this.getNumberValue(context, stream);
        return v == null ? 0 : v.intValue();
    }

    @Override
    public double getDoubleValue(MatchContext context, RutaStream stream) {
        Number v = this.getNumberValue(context, stream);
        return v == null ? 0.0 : v.doubleValue();
    }

    @Override
    public float getFloatValue(MatchContext context, RutaStream stream) {
        Number v = this.getNumberValue(context, stream);
        return v == null ? 0.0f : v.floatValue();
    }

    private Number getNumberValue(MatchContext context, RutaStream stream) {
        AnnotationFS annotation = context.getAnnotation();
        Number result = null;
        List<AnnotationFS> list = this.getTargetAnnotation(annotation, this.fe, context, stream);
        Collection<? extends FeatureStructure> featureStructures = this.fe.getFeatureStructures(list, false, context, stream);
        if (!featureStructures.isEmpty()) {
            Type range;
            Feature feature = this.fe.getFeature(context, stream);
            FeatureStructure next = featureStructures.iterator().next();
            if (feature instanceof LazyFeature) {
                LazyFeature lazyFeature = (LazyFeature)feature;
                feature = lazyFeature.initialize(next);
            }
            if ("uima.cas.Byte".equals((range = feature.getRange()).getName())) {
                result = next.getByteValue(feature);
            } else if ("uima.cas.Double".equals(range.getName())) {
                result = next.getDoubleValue(feature);
            } else if ("uima.cas.Float".equals(range.getName())) {
                result = Float.valueOf(next.getFloatValue(feature));
            } else if ("uima.cas.Integer".equals(range.getName())) {
                result = next.getIntValue(feature);
            } else if ("uima.cas.Long".equals(range.getName())) {
                result = next.getLongValue(feature);
            } else if ("uima.cas.Short".equals(range.getName())) {
                result = next.getShortValue(feature);
            }
        }
        return result;
    }

    @Override
    public String getStringValue(MatchContext context, RutaStream stream) {
        return "" + this.getNumberValue(context, stream);
    }

    public FeatureExpression getFe() {
        return this.fe;
    }

    public void setFe(FeatureExpression fe) {
        this.fe = fe;
    }
}

