/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.ide.ui.text;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.uima.ruta.ide.RutaIdePlugin;
import org.apache.uima.ruta.ide.ui.text.RutaCorrectionProcessor;
import org.apache.uima.ruta.ide.ui.text.RutaTextTools;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.text.IColorManager;
import org.eclipse.jface.internal.text.html.HTMLTextPresenter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.quickassist.QuickAssistAssistant;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class RutaCorrectionAssistant
extends QuickAssistAssistant {
    private ITextViewer fViewer;
    private ITextEditor fEditor;
    private Position fPosition;
    private Annotation[] fCurrentAnnotations;

    public RutaCorrectionAssistant(ITextEditor editor) {
        Assert.isNotNull((Object)editor);
        this.fEditor = editor;
        RutaCorrectionProcessor processor = new RutaCorrectionProcessor(this);
        this.setQuickAssistProcessor(processor);
        this.setInformationControlCreator(this.getInformationControlCreator());
        RutaTextTools textTools = RutaIdePlugin.getDefault().getTextTools();
        IColorManager manager = textTools.getColorManager();
        IPreferenceStore store = RutaIdePlugin.getDefault().getPreferenceStore();
        Color c = RutaCorrectionAssistant.getColor(store, "content_assist_proposals_foreground", manager);
        this.setProposalSelectorForeground(c);
        c = RutaCorrectionAssistant.getColor(store, "content_assist_proposals_background", manager);
        this.setProposalSelectorBackground(c);
    }

    public IEditorPart getEditor() {
        return this.fEditor;
    }

    private IInformationControlCreator getInformationControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter());
            }
        };
    }

    private static Color getColor(IPreferenceStore store, String key, IColorManager manager) {
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)store, (String)key);
        return manager.getColor(rgb);
    }

    public void install(ISourceViewer sourceViewer) {
        super.install(sourceViewer);
        this.fViewer = sourceViewer;
    }

    public void uninstall() {
        super.uninstall();
    }

    public String showPossibleQuickAssists() {
        this.fPosition = null;
        this.fCurrentAnnotations = null;
        if (this.fViewer == null || this.fViewer.getDocument() == null) {
            return super.showPossibleQuickAssists();
        }
        ArrayList resultingAnnotations = new ArrayList(20);
        try {
            Point selectedRange = this.fViewer.getSelectedRange();
            int currOffset = selectedRange.x;
            int currLength = selectedRange.y;
            boolean goToClosest = currLength == 0;
            int newOffset = RutaCorrectionAssistant.collectQuickFixableAnnotations(this.fEditor, currOffset, goToClosest, resultingAnnotations);
            if (newOffset != currOffset) {
                this.storePosition(currOffset, currLength);
                this.fViewer.setSelectedRange(newOffset, 0);
                this.fViewer.revealRange(newOffset, 0);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        this.fCurrentAnnotations = resultingAnnotations.toArray(new Annotation[resultingAnnotations.size()]);
        return super.showPossibleQuickAssists();
    }

    private static IRegion getRegionOfInterest(ITextEditor editor, int invocationLocation) throws BadLocationException {
        IDocumentProvider documentProvider = editor.getDocumentProvider();
        if (documentProvider == null) {
            return null;
        }
        IDocument document = documentProvider.getDocument((Object)editor.getEditorInput());
        if (document == null) {
            return null;
        }
        return document.getLineInformationOfOffset(invocationLocation);
    }

    public static int collectQuickFixableAnnotations(ITextEditor editor, int invocationLocation, boolean goToClosest, ArrayList resultingAnnotations) throws BadLocationException {
        IAnnotationModel model = DLTKUIPlugin.getDocumentProvider().getAnnotationModel((Object)editor.getEditorInput());
        if (model == null) {
            return invocationLocation;
        }
        RutaCorrectionAssistant.ensureUpdatedAnnotations(editor);
        Iterator iter = model.getAnnotationIterator();
        if (goToClosest) {
            Position pos;
            IRegion lineInfo = RutaCorrectionAssistant.getRegionOfInterest(editor, invocationLocation);
            if (lineInfo == null) {
                return invocationLocation;
            }
            int rangeStart = lineInfo.getOffset();
            int rangeEnd = rangeStart + lineInfo.getLength();
            ArrayList<Annotation> allAnnotations = new ArrayList<Annotation>();
            ArrayList<Position> allPositions = new ArrayList<Position>();
            int bestOffset = Integer.MAX_VALUE;
            while (iter.hasNext()) {
                Annotation annot = (Annotation)iter.next();
                if (!RutaCorrectionProcessor.isQuickFixableType(annot) || (pos = model.getPosition(annot)) == null || !RutaCorrectionAssistant.isInside(pos.offset, rangeStart, rangeEnd)) continue;
                allAnnotations.add(annot);
                allPositions.add(pos);
                bestOffset = RutaCorrectionAssistant.processAnnotation(annot, pos, invocationLocation, bestOffset);
            }
            if (bestOffset == Integer.MAX_VALUE) {
                return invocationLocation;
            }
            for (int i = 0; i < allPositions.size(); ++i) {
                pos = (Position)allPositions.get(i);
                if (!RutaCorrectionAssistant.isInside(bestOffset, pos.offset, pos.offset + pos.length)) continue;
                resultingAnnotations.add(allAnnotations.get(i));
            }
            return bestOffset;
        }
        while (iter.hasNext()) {
            Position pos;
            Annotation annot = (Annotation)iter.next();
            if (!RutaCorrectionProcessor.isQuickFixableType(annot) || (pos = model.getPosition(annot)) == null || !RutaCorrectionAssistant.isInside(invocationLocation, pos.offset, pos.offset + pos.length)) continue;
            resultingAnnotations.add(annot);
        }
        return invocationLocation;
    }

    private static void ensureUpdatedAnnotations(ITextEditor editor) {
    }

    private static int processAnnotation(Annotation annot, Position pos, int invocationLocation, int bestOffset) {
        int newClosestPosition;
        int posBegin = pos.offset;
        int posEnd = posBegin + pos.length;
        if (RutaCorrectionAssistant.isInside(invocationLocation, posBegin, posEnd)) {
            return invocationLocation;
        }
        if (bestOffset == invocationLocation || (newClosestPosition = RutaCorrectionAssistant.computeBestOffset(posBegin, invocationLocation, bestOffset)) == -1 || newClosestPosition != bestOffset) {
            // empty if block
        }
        return bestOffset;
    }

    private static boolean isInside(int offset, int start, int end) {
        return offset == start || offset == end || offset > start && offset < end;
    }

    private static int computeBestOffset(int newOffset, int invocationLocation, int bestOffset) {
        if (newOffset <= invocationLocation) {
            if (bestOffset > invocationLocation) {
                return newOffset;
            }
            if (bestOffset <= newOffset) {
                return newOffset;
            }
            return -1;
        }
        if (newOffset <= bestOffset) {
            return newOffset;
        }
        return -1;
    }

    protected void possibleCompletionsClosed() {
        super.possibleCompletionsClosed();
        this.restorePosition();
    }

    private void storePosition(int currOffset, int currLength) {
        this.fPosition = new Position(currOffset, currLength);
    }

    private void restorePosition() {
        if (this.fPosition != null && !this.fPosition.isDeleted() && this.fViewer.getDocument() != null) {
            this.fViewer.setSelectedRange(this.fPosition.offset, this.fPosition.length);
            this.fViewer.revealRange(this.fPosition.offset, this.fPosition.length);
        }
        this.fPosition = null;
    }

    public boolean isUpdatedOffset() {
        return this.fPosition != null;
    }

    public Annotation[] getAnnotationsAtOffset() {
        return this.fCurrentAnnotations;
    }
}

