/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.testing.ui.views;

import java.util.Collection;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.caseditor.editor.AnnotationEditor;
import org.apache.uima.caseditor.editor.ICasDocument;
import org.apache.uima.caseditor.editor.ICasDocumentListener;
import org.apache.uima.caseditor.editor.ICasEditorInputListener;
import org.apache.uima.ruta.caseditor.view.tree.AnnotationTreeViewDragListener;
import org.apache.uima.ruta.testing.ui.views.EvaluationContentProvider;
import org.apache.uima.ruta.testing.ui.views.EvaluationLabelProvider;
import org.apache.uima.ruta.testing.ui.views.tree.TestEvaluationTree;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;

public class EvaluationViewPage
extends Page
implements ICasDocumentListener,
ISelectionListener,
ICasEditorInputListener {
    private CheckboxTreeViewer viewer;
    int current = 0;
    private AnnotationEditor editor;
    private ICasDocument document;
    private String type;

    public EvaluationViewPage(String type, AnnotationEditor editor) {
        this.type = type;
        this.editor = editor;
        this.document = editor.getDocument();
    }

    public Control getControl() {
        return this.viewer.getControl();
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
    }

    public TreeViewer getTreeViewer() {
        return this.viewer;
    }

    public void createControl(Composite parent) {
        this.viewer = new CheckboxTreeViewer(parent, 772);
        this.viewer.setContentProvider((IContentProvider)new EvaluationContentProvider(this.type));
        this.viewer.setLabelProvider((IBaseLabelProvider)new EvaluationLabelProvider(this));
        int ops = 3;
        Transfer[] transfers = new Transfer[]{TextTransfer.getInstance()};
        this.viewer.addDragSupport(ops, transfers, (DragSourceListener)new AnnotationTreeViewDragListener((StructuredViewer)this.viewer));
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.getSite().getPage().addSelectionListener((ISelectionListener)this);
        this.document.addChangeListener((ICasDocumentListener)this);
        this.editor.addCasEditorInputListener((ICasEditorInputListener)this);
        this.reloadTree();
    }

    private void reloadTree() {
        TestEvaluationTree tree = new TestEvaluationTree();
        tree.createTree(this.document.getCAS());
        this.viewer.setInput((Object)tree);
        this.viewer.refresh();
    }

    public void dispose() {
        this.getSite().getPage().removeSelectionListener((ISelectionListener)this);
        this.document.removeChangeListener((ICasDocumentListener)this);
        this.editor.removeCasEditorInputListener((ICasEditorInputListener)this);
        super.dispose();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
    }

    public void added(FeatureStructure newFeatureStructure) {
    }

    public void added(Collection<FeatureStructure> newFeatureStructure) {
    }

    public void removed(FeatureStructure deletedFeatureStructure) {
    }

    public void removed(Collection<FeatureStructure> deletedFeatureStructure) {
    }

    public void updated(FeatureStructure featureStructure) {
    }

    public void updated(Collection<FeatureStructure> featureStructure) {
    }

    public void changed() {
        this.reloadTree();
    }

    public void viewChanged(String oldViewName, String newViewName) {
        this.reloadTree();
    }

    public void casDocumentChanged(IEditorInput oldInput, ICasDocument oldDocument, IEditorInput newInput, ICasDocument newDocument) {
    }
}

