/*
 * Decompiled with CFR 0.152.
 */
package ojb.odmg.oql;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import java.io.StringReader;
import java.util.AbstractList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import ojb.broker.PersistenceBroker;
import ojb.broker.query.Criteria;
import ojb.broker.query.Query;
import ojb.broker.query.SelectionCriteria;
import ojb.odmg.DatabaseImpl;
import ojb.odmg.OJB;
import ojb.odmg.collections.DListImpl;
import ojb.odmg.oql.OQLLexer;
import ojb.odmg.oql.OQLParser;
import org.odmg.OQLQuery;
import org.odmg.QueryException;
import org.odmg.QueryInvalidException;
import org.odmg.QueryParameterCountInvalidException;
import org.odmg.QueryParameterTypeInvalidException;
import org.odmg.Transaction;

public class OQLQueryImpl
implements OQLQuery {
    private String queryString = null;
    private Query query = null;
    private Iterator bindIterator = null;
    static /* synthetic */ Class class$ojb$odmg$collections$DListImpl;

    public Query getQuery() {
        return this.query;
    }

    public void bind(Object parameter) throws QueryParameterCountInvalidException, QueryParameterTypeInvalidException {
        try {
            SelectionCriteria crit = (SelectionCriteria)this.bindIterator.next();
            crit.bind(parameter);
        }
        catch (Exception e) {
            throw new QueryParameterCountInvalidException(e.getMessage());
        }
    }

    private Vector flatten(Criteria crit, Vector acc) {
        Enumeration e = crit.getElements();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            if (o instanceof Criteria) {
                Criteria pc = (Criteria)o;
                this.flatten(pc, acc);
                continue;
            }
            SelectionCriteria c = (SelectionCriteria)o;
            acc.add(c);
        }
        return acc;
    }

    public void create(String query) throws QueryInvalidException {
        try {
            this.queryString = query;
            StringReader reader = new StringReader(this.queryString);
            OQLLexer lexer = new OQLLexer(reader);
            OQLParser parser = new OQLParser(lexer);
            this.query = parser.buildQuery();
            this.bindIterator = ((AbstractList)this.flatten(this.query.getCriteria(), new Vector())).iterator();
        }
        catch (RecognitionException e) {
            throw new QueryInvalidException(e.getMessage());
        }
        catch (TokenStreamException e) {
            throw new QueryInvalidException(e.getMessage());
        }
    }

    public Object execute() throws QueryException {
        try {
            PersistenceBroker broker = ((DatabaseImpl)OJB.getInstance().getDatabase(null)).getBroker();
            Transaction tx = OJB.getInstance().currentTransaction();
            boolean needsCommit = false;
            if (tx == null) {
                tx = OJB.getInstance().newTransaction();
                tx.begin();
                needsCommit = true;
            }
            DListImpl result = (DListImpl)broker.getCollectionByQuery(class$ojb$odmg$collections$DListImpl == null ? (class$ojb$odmg$collections$DListImpl = OQLQueryImpl.class$("ojb.odmg.collections.DListImpl")) : class$ojb$odmg$collections$DListImpl, this.query);
            if (needsCommit) {
                tx.commit();
            }
            return result;
        }
        catch (Exception e) {
            System.err.println("parser exception: " + e);
            e.printStackTrace();
            throw new QueryException();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

