/*
 * Decompiled with CFR 0.152.
 */
package ojb.odmg;

import java.util.Enumeration;
import java.util.Hashtable;
import ojb.broker.PersistenceBroker;
import ojb.odmg.DatabaseImpl;
import ojb.odmg.OJB;
import ojb.odmg.ObjectEnvelope;
import ojb.odmg.TransactionImpl;
import org.odmg.TransactionAbortedException;

public class ObjectEnvelopeTable {
    private TransactionImpl transaction;
    private Hashtable table = new Hashtable();

    public ObjectEnvelopeTable(TransactionImpl myTransaction) {
        this.transaction = myTransaction;
    }

    public void checkpoint() throws TransactionAbortedException {
        PersistenceBroker broker = ((DatabaseImpl)OJB.getInstance().getDatabase(null)).getBroker();
        try {
            broker.beginTransaction();
            Enumeration enumeration = this.table.elements();
            while (enumeration.hasMoreElements()) {
                ObjectEnvelope mod = (ObjectEnvelope)enumeration.nextElement();
                if (mod.hasChanged()) {
                    this.transaction.lock(mod.getObject(), 2);
                    mod.setModificationState(mod.getModificationState().markDirty());
                }
                mod.getModificationState().checkpoint(mod, broker);
            }
            broker.commitTransaction();
        }
        catch (Throwable t) {
            broker.abortTransaction();
            throw new TransactionAbortedException(t.getMessage());
        }
    }

    public void commit() throws TransactionAbortedException {
        PersistenceBroker broker = ((DatabaseImpl)OJB.getInstance().getDatabase(null)).getBroker();
        try {
            broker.beginTransaction();
            Enumeration enumeration = this.table.elements();
            while (enumeration.hasMoreElements()) {
                ObjectEnvelope mod = (ObjectEnvelope)enumeration.nextElement();
                if (mod.hasChanged()) {
                    this.transaction.lock(mod.getObject(), 2);
                    mod.setModificationState(mod.getModificationState().markDirty());
                }
                mod.getModificationState().commit(mod, broker);
            }
            broker.commitTransaction();
        }
        catch (Throwable t) {
            broker.abortTransaction();
            throw new TransactionAbortedException(t.getMessage());
        }
    }

    public void rollback() {
        Enumeration enumeration = this.table.elements();
        while (enumeration.hasMoreElements()) {
            ObjectEnvelope mod = (ObjectEnvelope)enumeration.nextElement();
            if (mod.hasChanged()) {
                mod.setModificationState(mod.getModificationState().markDirty());
            }
            mod.getModificationState().rollback(mod, null);
        }
    }

    public void remove(Object key) {
        this.table.remove(new Integer(System.identityHashCode(key)));
    }

    public Enumeration elements() {
        return this.table.elements();
    }

    public ObjectEnvelope get(Object key) {
        Integer keyInteger = new Integer(System.identityHashCode(key));
        ObjectEnvelope result = (ObjectEnvelope)this.table.get(keyInteger);
        if (result == null) {
            result = new ObjectEnvelope(key);
            this.table.put(keyInteger, result);
        }
        return result;
    }

    public void put(Object key, ObjectEnvelope modification) {
        Integer keyInt = new Integer(System.identityHashCode(key));
        this.table.put(keyInt, modification);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("### ObjectEnvelopeTable dump:\n");
        Enumeration enumeration = this.table.elements();
        while (enumeration.hasMoreElements()) {
            ObjectEnvelope mod = (ObjectEnvelope)enumeration.nextElement();
            buf.append(mod.toString());
            buf.append("\n");
        }
        return buf.toString();
    }

    public boolean contains(Object key) {
        Integer keyInteger = new Integer(System.identityHashCode(key));
        ObjectEnvelope result = (ObjectEnvelope)this.table.get(keyInteger);
        return result != null;
    }
}

