/*
 * Decompiled with CFR 0.152.
 */
package ojb.broker.accesslayer;

import java.util.Enumeration;
import ojb.broker.metadata.ClassDescriptor;
import ojb.broker.metadata.FieldDescriptor;
import ojb.broker.metadata.PersistentField;
import ojb.broker.query.Criteria;
import ojb.broker.query.Query;
import ojb.broker.query.SelectionCriteria;

public class SqlGenerator {
    private static SqlGenerator _instance;
    private static boolean _debug;

    private SqlGenerator() {
    }

    public static SqlGenerator getInstance() {
        if (_instance == null) {
            _instance = new SqlGenerator();
        }
        return _instance;
    }

    public static void setDebug(boolean b) {
        _debug = b;
    }

    private String getListOfColumns(ClassDescriptor mif) {
        String list = null;
        FieldDescriptor[] fields = mif.getFieldDescriptions();
        int i = 0;
        while (i < fields.length) {
            FieldDescriptor fmd = fields[i];
            String cn = fmd.getColumnName();
            list = list == null ? this.quote(cn) : list + ", " + this.quote(cn);
            ++i;
        }
        return list;
    }

    private String quote(String col) {
        return col;
    }

    private String quoteIfNeeded(String str, String dbtype) {
        String[] quotables = new String[]{"DATE", "TIME", "CHAR", "STRING"};
        boolean test = false;
        int i = 0;
        while (i < quotables.length) {
            if (dbtype.startsWith(quotables[i])) {
                test = true;
                break;
            }
            ++i;
        }
        if (test) {
            str = this.escapeSingleQuotes(str);
            return "'" + str + "'";
        }
        return str;
    }

    private String escapeSingleQuotes(String str) {
        String result = str;
        if (str.indexOf("'") != -1) {
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < str.length()) {
                char c = str.charAt(i);
                if (c == '\'') {
                    buf.append("\\'");
                } else {
                    buf.append(c);
                }
                ++i;
            }
            result = buf.toString();
        }
        return result;
    }

    protected String asSQLClause(SelectionCriteria c, ClassDescriptor cld) {
        String colName = cld != null ? cld.getFieldDescriptorByName(c.getAttribute()).getColumnName() : c.getAttribute();
        return colName + c.getClause() + " ? ";
    }

    public String asSQLStatement(Criteria crit, ClassDescriptor cld) {
        Enumeration e = crit.getElements();
        StringBuffer statement = new StringBuffer();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            if (o instanceof Criteria) {
                String addAtEnd;
                String addAtStart;
                Criteria pc = (Criteria)o;
                if (pc.isEmbraced()) {
                    addAtStart = " (";
                    addAtEnd = ") ";
                } else {
                    addAtStart = "";
                    addAtEnd = "";
                }
                switch (pc.getType()) {
                    case 0: {
                        statement.append(" OR " + addAtStart);
                        statement.append(this.asSQLStatement(pc, cld));
                        statement.append(addAtEnd);
                        break;
                    }
                    case 1: {
                        statement.insert(0, "( ");
                        statement.append(") ");
                        statement.append(" AND " + addAtStart);
                        statement.append(this.asSQLStatement(pc, cld));
                        statement.append(addAtEnd);
                    }
                }
                continue;
            }
            SelectionCriteria c = (SelectionCriteria)o;
            if (statement.length() == 0) {
                statement.append(this.asSQLClause(c, cld));
                continue;
            }
            statement.insert(0, "(");
            statement.append(") ");
            statement.append(" AND ");
            statement.append(this.asSQLClause(c, cld));
        }
        if (statement.length() == 0) {
            return null;
        }
        return statement.toString();
    }

    private String getListOfValues(ClassDescriptor mif) {
        String list = "";
        FieldDescriptor[] fields = mif.getFieldDescriptions();
        int i = 0;
        while (i < fields.length) {
            FieldDescriptor fmd = fields[i];
            PersistentField f = fmd.getPersistentField();
            if (list != "") {
                list = list + ", ";
            }
            list = list + "?";
            ++i;
        }
        return list;
    }

    public String getPreparedDeleteStatement(ClassDescriptor mif) {
        String scm = mif.getScheme();
        String tbl = mif.getTableName();
        if (scm != null) {
            tbl = scm + "." + tbl;
        }
        String stmt = "DELETE ";
        stmt = stmt + " FROM " + tbl;
        stmt = stmt + this.getWhereClause(mif);
        return stmt;
    }

    public String getPreparedInsertStatement(ClassDescriptor mif) {
        String scm = mif.getScheme();
        String tbl = mif.getTableName();
        if (scm != null) {
            tbl = scm + "." + tbl;
        }
        String qry = "INSERT INTO " + tbl;
        qry = qry + " (" + this.getListOfColumns(mif) + ")";
        qry = qry + " VALUES (" + this.getListOfValues(mif) + ")";
        return qry;
    }

    public String getPreparedSelectByPkStatement(ClassDescriptor mif) {
        String scm = mif.getScheme();
        String tbl = mif.getTableName();
        if (scm != null) {
            tbl = scm + "." + tbl;
        }
        String stmt = "SELECT ";
        stmt = stmt + this.getListOfColumns(mif);
        stmt = stmt + " FROM " + tbl;
        stmt = stmt + this.getWhereClause(mif);
        return stmt;
    }

    public String getPreparedSelectStatement(Query query, ClassDescriptor mif) {
        String scm = mif.getScheme();
        String tbl = mif.getTableName();
        if (scm != null) {
            tbl = scm + "." + tbl;
        }
        String stmt = "SELECT ";
        stmt = stmt + this.getListOfColumns(mif);
        stmt = stmt + " FROM " + tbl;
        stmt = stmt + this.getWhereClause(query, mif);
        String orderbyField = query.getCriteria().getOrderby();
        if (orderbyField != null) {
            FieldDescriptor fld = mif.getFieldDescriptorByName(orderbyField);
            String orderbyColumn = fld.getColumnName();
            stmt = stmt + " ORDER BY " + orderbyColumn;
            if (!query.getCriteria().isAscending()) {
                stmt = stmt + " DESC";
            }
        }
        return stmt;
    }

    public String getPreparedUpdateStatement(ClassDescriptor mif) {
        String scm = mif.getScheme();
        String tbl = mif.getTableName();
        if (scm != null) {
            tbl = scm + "." + tbl;
        }
        String stmt = "UPDATE " + tbl;
        stmt = stmt + this.getSetClause(mif);
        stmt = stmt + this.getWhereClause(mif);
        return stmt;
    }

    public String getSelectStatementDep(Query query, ClassDescriptor mif) {
        String orderbyField;
        String scm = mif.getScheme();
        String tbl = mif.getTableName();
        if (scm != null) {
            tbl = scm + "." + tbl;
        }
        String stmt = "SELECT ";
        stmt = stmt + this.getListOfColumns(mif);
        stmt = stmt + " FROM " + tbl;
        stmt = stmt + this.getWhereClause(query, mif);
        if (query.getCriteria() != null && (orderbyField = query.getCriteria().getOrderby()) != null) {
            FieldDescriptor fld = mif.getFieldDescriptorByName(orderbyField);
            String orderbyColumn = fld.getColumnName();
            stmt = stmt + " ORDER BY " + orderbyColumn;
            if (!query.getCriteria().isAscending()) {
                stmt = stmt + " DESC";
            }
        }
        return stmt;
    }

    private String getSetClause(ClassDescriptor mif) {
        String clause = "";
        FieldDescriptor[] fields = mif.getFieldDescriptions();
        int i = 0;
        while (i < fields.length) {
            FieldDescriptor fmd = fields[i];
            if (!fmd.isPrimaryKey()) {
                PersistentField f = fmd.getPersistentField();
                String cn = this.quote(fmd.getColumnName());
                clause = clause.equals("") ? " SET " : clause + ", ";
                clause = clause + cn + " = ?";
            }
            ++i;
        }
        return clause;
    }

    private String getWhereClause(ClassDescriptor mif) {
        String clause = "";
        FieldDescriptor[] pkFields = mif.getPkFields();
        return this.getWhereClause(pkFields, null, mif);
    }

    private String getWhereClause(Query query, ClassDescriptor mif) {
        if (query.getCriteria() != null) {
            String clause = this.asSQLStatement(query.getCriteria(), mif);
            if (clause != null) {
                return " WHERE " + clause;
            }
            return "";
        }
        return "";
    }

    private String getWhereClause(FieldDescriptor[] fields, Object[] values, ClassDescriptor mif) {
        String clause = "";
        int i = 0;
        while (i < fields.length) {
            FieldDescriptor fmd = fields[i];
            PersistentField f = fmd.getPersistentField();
            String cn = fmd.getColumnName();
            String ct = fmd.getColumnType();
            clause = clause.equals("") ? " WHERE " : clause + " AND ";
            String val = null;
            if (values != null) {
                try {
                    val = this.quoteIfNeeded(values[i].toString(), ct);
                }
                catch (Exception ex) {
                    System.out.println("Vector of FieldDescriptors " + fields + " and Vector of values " + values + " differ in size");
                    ex.printStackTrace();
                }
            } else {
                val = "?";
            }
            clause = clause + "(" + this.quote(cn) + " = " + val + ")";
            ++i;
        }
        return clause;
    }

    static {
        _debug = false;
    }
}

