/*
 * Decompiled with CFR 0.152.
 */
package ojb.broker;

import java.io.IOException;
import java.net.MalformedURLException;
import javax.xml.parsers.ParserConfigurationException;
import ojb.broker.PersistenceBroker;
import ojb.broker.metadata.DescriptorRepository;
import ojb.broker.server.PersistenceBrokerClient;
import ojb.broker.server.ServerPool;
import ojb.broker.singlevm.PersistenceBrokerImpl;
import ojb.broker.util.PersistenceBrokerFactoryConfiguration;
import org.xml.sax.SAXException;

public class PersistenceBrokerFactory {
    private static DescriptorRepository repository = null;
    private static PersistenceBroker lastServed;
    private static PersistenceBrokerFactoryConfiguration configuration;

    public static PersistenceBrokerFactoryConfiguration getConfiguration() {
        return configuration;
    }

    public static PersistenceBroker createPersistenceBroker(String repositoryFile) throws MalformedURLException, ParserConfigurationException, SAXException, IOException {
        if (repository == null) {
            repository = DescriptorRepository.getInstance(repositoryFile);
        }
        if (configuration.isServerUsed()) {
            ServerPool pool = new ServerPool(configuration.getServers());
            lastServed = new PersistenceBrokerClient(pool);
            return lastServed;
        }
        lastServed = new PersistenceBrokerImpl(repository);
        return lastServed;
    }

    public static PersistenceBroker createPersistenceBroker() {
        if (lastServed != null) {
            return lastServed;
        }
        try {
            return PersistenceBrokerFactory.createPersistenceBroker(configuration.getRepositoryFilename());
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
            System.exit(1);
            return null;
        }
    }

    static {
        configuration = new PersistenceBrokerFactoryConfiguration();
    }
}

