/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.messenger;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.messenger.Messenger;
import org.apache.commons.messenger.MessengerManager;

public class MessengerServlet
extends HttpServlet {
    private static final String KEY_MESSENGER = "messenger";
    private static final String KEY_DESTINATION = "destination";
    private Messenger messenger;
    private Destination destination;

    public void init() throws ServletException {
        try {
            String name = this.getRequiredInitParmeter(KEY_MESSENGER, "Name of the Messenger to use for this servlet");
            String subject = this.getRequiredInitParmeter(KEY_DESTINATION, "Destination to be used for this servlet");
            Messenger messenger = MessengerManager.get(name);
            if (messenger == null) {
                throw new ServletException("No Messenger configuration exists for name: " + name);
            }
            Destination destination = messenger.getDestination(subject);
            if (destination == null) {
                throw new ServletException("No Destination exists for subject: " + subject);
            }
            this.setMessenger(messenger);
            this.setDestination(destination);
        }
        catch (JMSException e) {
            throw new ServletException("Failed to initialise Messenger and Destination: " + (Object)((Object)e), (Throwable)e);
        }
    }

    public Messenger getMessenger() {
        return this.messenger;
    }

    public void setMessenger(Messenger messenger) {
        this.messenger = messenger;
    }

    public Destination getDestination() {
        return this.destination;
    }

    public void setDestination(Destination destination) {
        this.destination = destination;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        try {
            Message message = this.getMessenger().receiveNoWait(this.getDestination());
            if (message != null) {
                this.writeMessage(message, request, response);
            }
        }
        catch (IOException e) {
            throw new ServletException((Throwable)e);
        }
        catch (JMSException e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        try {
            Message message = this.readMessage(request, response);
            if (message != null) {
                this.getMessenger().send(this.getDestination(), message);
            }
        }
        catch (IOException e) {
            throw new ServletException((Throwable)e);
        }
        catch (JMSException e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        try {
            Message message = this.readMessage(request, response);
            if (message != null) {
                this.getMessenger().send(this.getDestination(), message);
            }
        }
        catch (IOException e) {
            throw new ServletException((Throwable)e);
        }
        catch (JMSException e) {
            throw new ServletException((Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected Message readMessage(HttpServletRequest request, HttpServletResponse response) throws IOException, JMSException, ServletException {
        String line;
        StringBuffer buffer = new StringBuffer();
        BufferedReader reader = request.getReader();
        while ((line = reader.readLine()) != null) {
            void var5_5;
            buffer.append((String)var5_5);
        }
        String text = buffer.toString();
        Object message = null;
        message = text.length() == 0 ? this.getMessenger().createMessage() : this.getMessenger().createTextMessage(text);
        return message;
    }

    protected void writeMessage(Message message, HttpServletRequest request, HttpServletResponse response) throws IOException, JMSException, ServletException {
        PrintWriter writer = response.getWriter();
        if (message instanceof TextMessage) {
            TextMessage textMessage = (TextMessage)message;
            writer.write(textMessage.getText());
        }
    }

    protected String getRequiredInitParmeter(String key, String description) throws ServletException {
        String value = this.getInitParameter(key);
        if (value == null || value.length() == 0) {
            throw new ServletException("No initialization parameter for parameter: " + key + " description: " + description);
        }
        return value;
    }
}

