/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.messenger;

import java.net.URL;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import org.apache.commons.messenger.MessengerManager;

public class InitMessengerServlet
extends HttpServlet {
    private static boolean initialized = false;

    public void init() throws ServletException {
        if (!initialized) {
            initialized = true;
            this.getServletContext().log("About to initialize MessengerManager");
            String config = this.getRequiredInitParmeter("config", "The URL of the Messenger XML deployment document");
            try {
                URL url = this.getServletContext().getResource(config);
                MessengerManager.configure(url.toString());
            }
            catch (Exception e) {
                throw new ServletException("Failed to initialise MessengerManager from config: " + config + ". Reason : " + e, (Throwable)e);
            }
        }
    }

    protected String getRequiredInitParmeter(String key, String description) throws ServletException {
        String value = this.getInitParameter(key);
        if (value == null || value.length() == 0) {
            throw new ServletException("No initialization parameter for parameter: " + key + " description: " + description);
        }
        return value;
    }
}

