/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.loader;

import jakarta.servlet.ServletContext;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.apache.openejb.config.NewLoaderLogic;
import org.apache.openejb.util.URLs;
import org.apache.tomcat.JarScanFilter;
import org.apache.tomcat.JarScanType;
import org.apache.tomcat.JarScannerCallback;
import org.apache.tomcat.util.scan.StandardJarScanner;
import org.apache.xbean.finder.ClassLoaders;
import org.apache.xbean.finder.filter.Filter;
import org.apache.xbean.finder.filter.Filters;

public class TomEEJarScanner
extends StandardJarScanner {
    private static final TomEEFilter DEFAULT_JAR_SCAN_FILTER = new TomEEFilter(null);

    public TomEEJarScanner() {
        this.setJarScanFilter(DEFAULT_JAR_SCAN_FILTER);
    }

    private void configureFilter(JarScanFilter jarScanFilter) {
        this.setJarScanFilter(new TomEEFilter(jarScanFilter));
    }

    public void setJarScanFilter(JarScanFilter jarScanFilter) {
        super.setJarScanFilter(jarScanFilter);
        if (!TomEEFilter.class.isInstance(jarScanFilter)) {
            this.configureFilter(jarScanFilter);
        }
    }

    public void scan(JarScanType scanType, ServletContext context, JarScannerCallback callback) {
        super.scan(scanType, context, callback);
        if (!this.embeddedSurefireScanning(scanType, context, callback) && this.isScanClassPath() && !URLClassLoader.class.isInstance(ClassLoader.getSystemClassLoader()) && !Boolean.getBoolean("tomee.classpath.scanning.disabled")) {
            String cp = System.getProperty("java.class.path");
            HashSet<URL> urls = new HashSet<URL>();
            for (String jar : cp.split(File.pathSeparator)) {
                if (jar.isEmpty()) continue;
                try {
                    urls.add(new File(jar).toURI().toURL());
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            this.doScan(scanType, callback, new LinkedList<URL>(urls));
        }
    }

    private boolean embeddedSurefireScanning(JarScanType scanType, ServletContext context, JarScannerCallback callback) {
        if (this.isScanClassPath() && System.getProperty("surefire.real.class.path") != null) {
            try {
                Set urls = ClassLoaders.findUrls((ClassLoader)context.getClassLoader().getParent());
                this.doScan(scanType, callback, new LinkedList<URL>(urls));
                return true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    private void doScan(JarScanType scanType, JarScannerCallback callback, Deque<URL> urls) {
        Method process = null;
        boolean scanAllDirectories = this.isScanAllDirectories();
        for (URL url : urls) {
            File cpe = URLs.toFile((URL)url);
            if (!cpe.getName().endsWith(".jar") && scanType != JarScanType.PLUGGABILITY && !scanAllDirectories || !this.getJarScanFilter().check(scanType, cpe.getName())) continue;
            try {
                if (process == null && !(process = StandardJarScanner.class.getDeclaredMethod("process", JarScanType.class, JarScannerCallback.class, URL.class, String.class, Boolean.TYPE, Deque.class)).isAccessible()) {
                    process.setAccessible(true);
                }
                process.invoke((Object)this, scanType, callback, url, null, true, urls);
            }
            catch (Exception exception) {}
        }
    }

    public static class TomEEFilter
    implements JarScanFilter {
        private static final Filter INCLUDE = Filters.tokens((String[])new String[]{"jakarta.faces-2.", "jakarta.faces-2.", "jakarta.faces-3.", "jakarta.faces-4.", "spring-security-taglibs", "spring-webmvc"});
        private final JarScanFilter delegate;

        public TomEEFilter() {
            this(null);
        }

        public TomEEFilter(JarScanFilter jarScanFilter) {
            this.delegate = jarScanFilter;
        }

        public boolean check(JarScanType jarScanType, String jarName) {
            if (jarScanType == JarScanType.TLD) {
                if (INCLUDE.accept(jarName)) {
                    return true;
                }
                if (jarName.startsWith("tomcat-websocket") || jarName.startsWith("myfaces-impl")) {
                    return false;
                }
            }
            if (jarName.startsWith("johnzon-") || jarName.startsWith("xx-arquillian-tomee-")) {
                return false;
            }
            return !NewLoaderLogic.skip((String)jarName) && (this.delegate == null || this.delegate.check(jarScanType, jarName));
        }

        public JarScanFilter getDelegate() {
            return this.delegate;
        }
    }
}

