/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config._private;

import io.smallrye.config._private.ConfigMessages;
import java.io.InvalidObjectException;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.regex.Pattern;
import org.eclipse.microprofile.config.spi.Converter;

public class ConfigMessages_$bundle
implements ConfigMessages,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final ConfigMessages_$bundle INSTANCE = new ConfigMessages_$bundle();
    private static final Locale LOCALE = Locale.ROOT;

    protected ConfigMessages_$bundle() {
    }

    protected Object readResolve() {
        return INSTANCE;
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String fileNotFound$str() {
        return "The file %s was not found";
    }

    @Override
    public final IllegalStateException fileNotFound(String fileName) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.fileNotFound$str(), fileName));
        ConfigMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String failedToLoadConfig$str() {
        return "SRCFG00001: Failure while loading microprofile-config.properties files";
    }

    @Override
    public final IllegalStateException failedToLoadConfig(Throwable throwable) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.failedToLoadConfig$str(), new Object[0]), throwable);
        ConfigMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedCharacterConversion$str() {
        return "SRCFG00002: %s can not be converted to a Character";
    }

    @Override
    public final IllegalArgumentException failedCharacterConversion(String value) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.failedCharacterConversion$str(), value));
        ConfigMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String singleTypeConverter$str() {
        return "SRCFG00003: Converter %s must be parameterized with a single type";
    }

    @Override
    public final IllegalStateException singleTypeConverter(String className) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.singleTypeConverter$str(), className));
        ConfigMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String notArrayType$str() {
        return "SRCFG00004: %s is not an array type";
    }

    @Override
    public final IllegalArgumentException notArrayType(String arrayType) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.notArrayType$str(), arrayType));
        ConfigMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String valueNotMatchPattern$str() {
        return "SRCFG00005: Value does not match pattern %s (value was \"%s\")";
    }

    @Override
    public final IllegalArgumentException valueNotMatchPattern(Pattern pattern, String value) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.valueNotMatchPattern$str(), pattern, value));
        ConfigMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String lessThanMinimumValue$str() {
        return "SRCFG00006: Value must not be less than %s (value was \"%s\")";
    }

    @Override
    public final IllegalArgumentException lessThanMinimumValue(Object minimum, String value) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.lessThanMinimumValue$str(), minimum, value));
        ConfigMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String lessThanEqualToMinimumValue$str() {
        return "SRCFG00007: Value must not be less than or equal to %s (value was \"%s\")";
    }

    @Override
    public final IllegalArgumentException lessThanEqualToMinimumValue(Object minimum, String value) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.lessThanEqualToMinimumValue$str(), minimum, value));
        ConfigMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String greaterThanMaximumValue$str() {
        return "SRCFG00008: Value must not be greater than %s (value was \"%s\")";
    }

    @Override
    public final IllegalArgumentException greaterThanMaximumValue(Object maximum, String value) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.greaterThanMaximumValue$str(), maximum, value));
        ConfigMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String greaterThanEqualToMaximumValue$str() {
        return "SRCFG00009: Value must not be greater than or equal to %s (value was \"%s\")";
    }

    @Override
    public final IllegalArgumentException greaterThanEqualToMaximumValue(Object maximum, String value) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.greaterThanEqualToMaximumValue$str(), maximum, value));
        ConfigMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unknownConverterId$str() {
        return "SRCFG00010: Unknown converter ID: %s";
    }

    @Override
    public final InvalidObjectException unknownConverterId(int id) {
        InvalidObjectException result = new InvalidObjectException(String.format(this.getLoggingLocale(), this.unknownConverterId$str(), id));
        ConfigMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String expandingElementNotFound$str() {
        return "SRCFG00011: Could not expand value %s in property %s";
    }

    @Override
    public final NoSuchElementException expandingElementNotFound(String key, String valueName) {
        NoSuchElementException result = new NoSuchElementException(String.format(this.getLoggingLocale(), this.expandingElementNotFound$str(), key, valueName));
        ConfigMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToAddConverter$str() {
        return "SRCFG00012: Can not add converter %s that is not parameterized with a type";
    }

    @Override
    public final IllegalStateException unableToAddConverter(Converter<?> converter) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.unableToAddConverter$str(), converter));
        ConfigMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noRegisteredConverter$str() {
        return "SRCFG00013: No Converter registered for %s";
    }

    @Override
    public final IllegalArgumentException noRegisteredConverter(Class<?> type) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.noRegisteredConverter$str(), type));
        ConfigMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String propertyNotFound$str() {
        return "SRCFG00014: The config property %s is required but it could not be found in any config source";
    }

    @Override
    public final String propertyNotFound(String name) {
        return String.format(this.getLoggingLocale(), this.propertyNotFound$str(), name);
    }

    protected String noConfigForClassloader$str() {
        return "SRCFG00015: No configuration is available for this class loader";
    }

    @Override
    public final IllegalStateException noConfigForClassloader() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.noConfigForClassloader$str(), new Object[0]));
        ConfigMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String configIsNull$str() {
        return "SRCFG00016: config cannot be null";
    }

    @Override
    public final IllegalArgumentException configIsNull() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.configIsNull$str(), new Object[0]));
        ConfigMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String configAlreadyRegistered$str() {
        return "SRCFG00017: Configuration already registered for the given class loader";
    }

    @Override
    public final IllegalStateException configAlreadyRegistered() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.configAlreadyRegistered$str(), new Object[0]));
        ConfigMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String malformedEncoding$str() {
        return "SRCFG00018: Malformed \\uxxxx encoding";
    }

    @Override
    public final IllegalArgumentException malformedEncoding() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.malformedEncoding$str(), new Object[0]));
        ConfigMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String constructorConverterFailure$str() {
        return "SRCFG00019: Failed to create new instance from Converter constructor";
    }

    @Override
    public final IllegalArgumentException constructorConverterFailure(Throwable cause) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.constructorConverterFailure$str(), new Object[0]), cause);
        ConfigMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String staticMethodConverterFailure$str() {
        return "SRCFG00020: Failed to convert value with static method";
    }

    @Override
    public final IllegalArgumentException staticMethodConverterFailure(Throwable cause) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.staticMethodConverterFailure$str(), new Object[0]), cause);
        ConfigMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String classConverterNotFound$str() {
        return "SRCFG00021: Converter class %s not found";
    }

    @Override
    public final IllegalArgumentException classConverterNotFound(Throwable cause, String className) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.classConverterNotFound$str(), className), cause);
        ConfigMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unknownHost$str() {
        return "SRCFG00022: Host, %s, not found";
    }

    @Override
    public final IllegalArgumentException unknownHost(Throwable cause, String host) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.unknownHost$str(), host), cause);
        ConfigMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unknownArrayType$str() {
        return "SRCFG00023: Array type being converted is unknown";
    }

    @Override
    public final IllegalArgumentException unknownArrayType() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.unknownArrayType$str(), new Object[0]));
        ConfigMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String notAllowed$str() {
        return "SRCFG00024: Not allowed to access secret key %s";
    }

    @Override
    public final SecurityException notAllowed(String name) {
        SecurityException result = new SecurityException(String.format(this.getLoggingLocale(), this.notAllowed$str(), name));
        ConfigMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String expressionExpansionTooDepth$str() {
        return "SRCFG00025: Recursive expression expansion is too deep for %s";
    }

    @Override
    public final IllegalArgumentException expressionExpansionTooDepth(String name) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.expressionExpansionTooDepth$str(), name));
        ConfigMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String malformedUUID$str() {
        return "SRCFG00026: %s cannot be converted into a UUID";
    }

    @Override
    public final IllegalArgumentException malformedUUID(Throwable cause, String malformedUUID) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.malformedUUID$str(), malformedUUID), cause);
        ConfigMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String mappingNotFound$str() {
        return "SRCFG00027: Could not find a mapping for %s";
    }

    @Override
    public final NoSuchElementException mappingNotFound(String className) {
        NoSuchElementException result = new NoSuchElementException(String.format(this.getLoggingLocale(), this.mappingNotFound$str(), className));
        ConfigMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String mappingPrefixNotFound$str() {
        return "SRCFG00028: Could not find a mapping for %s with prefix %s";
    }

    @Override
    public final NoSuchElementException mappingPrefixNotFound(String className, String prefix) {
        NoSuchElementException result = new NoSuchElementException(String.format(this.getLoggingLocale(), this.mappingPrefixNotFound$str(), className, prefix));
        ConfigMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String integerExpected$str() {
        return "SRCFG00029: Expected an integer value, got \"%s\"";
    }

    @Override
    public final NumberFormatException integerExpected(String value) {
        NumberFormatException result = new NumberFormatException(String.format(this.getLoggingLocale(), this.integerExpected$str(), value));
        ConfigMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String longExpected$str() {
        return "SRCFG00030: Expected a long value, got \"%s\"";
    }

    @Override
    public final NumberFormatException longExpected(String value) {
        NumberFormatException result = new NumberFormatException(String.format(this.getLoggingLocale(), this.longExpected$str(), value));
        ConfigMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String doubleExpected$str() {
        return "SRCFG00031: Expected a double value, got \"%s\"";
    }

    @Override
    public final NumberFormatException doubleExpected(String value) {
        NumberFormatException result = new NumberFormatException(String.format(this.getLoggingLocale(), this.doubleExpected$str(), value));
        ConfigMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String floatExpected$str() {
        return "SRCFG00032: Expected a float value, got \"%s\"";
    }

    @Override
    public final NumberFormatException floatExpected(String value) {
        NumberFormatException result = new NumberFormatException(String.format(this.getLoggingLocale(), this.floatExpected$str(), value));
        ConfigMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String schemeNotSupported$str() {
        return "SRCFG00033: Scheme %s not supported";
    }

    @Override
    public final IllegalArgumentException schemeNotSupported(String scheme) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.schemeNotSupported$str(), scheme));
        ConfigMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String uriSyntaxInvalid$str() {
        return "SRCFG00034: URI Syntax invalid %s";
    }

    @Override
    public final IllegalArgumentException uriSyntaxInvalid(Throwable cause, String uri) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.uriSyntaxInvalid$str(), uri), cause);
        ConfigMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedToLoadResource$str() {
        return "SRCFG00035: Failed to load resource %s";
    }

    @Override
    public final IllegalArgumentException failedToLoadResource(Throwable cause, String location) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.failedToLoadResource$str(), location), cause);
        ConfigMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String getTypeNotSupportedForUnwrapping$str() {
        return "SRCFG00036: Type %s not supported for unwrapping.";
    }

    @Override
    public final IllegalArgumentException getTypeNotSupportedForUnwrapping(Class<?> type) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.getTypeNotSupportedForUnwrapping$str(), type));
        ConfigMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String converterNullValue$str() {
        return "SRCFG00037: The Converter API cannot convert a null value";
    }

    @Override
    public final NullPointerException converterNullValue() {
        NullPointerException result = new NullPointerException(String.format(this.getLoggingLocale(), this.converterNullValue$str(), new Object[0]));
        ConfigMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noRawType$str() {
        return "SRCFG00038: Type has no raw type class: %s";
    }

    @Override
    public final IllegalArgumentException noRawType(Type type) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.noRawType$str(), type));
        ConfigMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String converterException$str() {
        return "SRCFG00039: The config property %s with the config value \"%s\" threw an Exception whilst being converted %s";
    }

    @Override
    public final IllegalArgumentException converterException(Throwable converterException, String configProperty, String configValue, String causeMessage) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.converterException$str(), configProperty, configValue, causeMessage), converterException);
        ConfigMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String propertyEmptyString$str() {
        return "SRCFG00040: The config property %s is defined as the empty String (\"\") which the following Converter considered to be null: %s";
    }

    @Override
    public final NoSuchElementException propertyEmptyString(String configPropertyName, String converter) {
        NoSuchElementException result = new NoSuchElementException(String.format(this.getLoggingLocale(), this.propertyEmptyString$str(), configPropertyName, converter));
        ConfigMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String converterReturnedNull$str() {
        return "SRCFG00041: The config property %s with the config value \"%s\" was converted to null from the following Converter: %s";
    }

    @Override
    public final NoSuchElementException converterReturnedNull(String configPropertyName, String configValue, String converter) {
        NoSuchElementException result = new NoSuchElementException(String.format(this.getLoggingLocale(), this.converterReturnedNull$str(), configPropertyName, configValue, converter));
        ConfigMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String valueNotMatchMapFormat$str() {
        return "SRCFG00042: Value does not match the expected map format \"<key1>=<value1>;<key2>=<value2>...\" (value was \"%s\")";
    }

    @Override
    public final NoSuchElementException valueNotMatchMapFormat(String value) {
        NoSuchElementException result = new NoSuchElementException(String.format(this.getLoggingLocale(), this.valueNotMatchMapFormat$str(), value));
        ConfigMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String mappingAnnotationNotSupportedInClass$str() {
        return "SRCFG00043: The @ConfigMapping annotation can only be placed in interfaces, %s is a class";
    }

    @Override
    public final IllegalStateException mappingAnnotationNotSupportedInClass(Class<?> type) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.mappingAnnotationNotSupportedInClass$str(), type));
        ConfigMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String propertiesAnnotationNotSupportedInInterface$str() {
        return "SRCFG00044: The @ConfigProperties annotation can only be placed in classes, %s is an interface";
    }

    @Override
    public final IllegalStateException propertiesAnnotationNotSupportedInInterface(Class<?> type) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.propertiesAnnotationNotSupportedInInterface$str(), type));
        ConfigMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String classIsNotAMapping$str() {
        return "SRCFG00045: The %s class is not a ConfigMapping";
    }

    @Override
    public final IllegalArgumentException classIsNotAMapping(Class<?> type) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.classIsNotAMapping$str(), type));
        ConfigMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String secretKeyHandlerNotFound$str() {
        return "SRCFG00046: Could not find a secret key handler for %s";
    }

    @Override
    public final NoSuchElementException secretKeyHandlerNotFound(String handler) {
        NoSuchElementException result = new NoSuchElementException(String.format(this.getLoggingLocale(), this.secretKeyHandlerNotFound$str(), handler));
        ConfigMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String ambiguousMapping$str() {
        return "SRCFG00047: The ConfigMapping path %s is ambiguous. It is mapped by %s and %s";
    }

    @Override
    public final IllegalStateException ambiguousMapping(String path, String amb1, String amb2) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.ambiguousMapping$str(), path, amb1, amb2));
        ConfigMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String explicitNameInUnnamed$str() {
        return "SRCFG00048: The config property %s explicitly defined the key %s, but the key is marked as unnamed";
    }

    @Override
    public final IllegalArgumentException explicitNameInUnnamed(String name, String key) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.explicitNameInUnnamed$str(), name, key));
        ConfigMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotConvertEnum$str() {
        return "SRCFG00049: Cannot convert %s to enum %s, allowed values: %s";
    }

    @Override
    public final IllegalArgumentException cannotConvertEnum(String value, Class<?> enumType, String values) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.cannotConvertEnum$str(), value, enumType, values));
        ConfigMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String propertyDoesNotMapToAnyRoot$str() {
        return "SRCFG00050: %s in %s does not map to any root";
    }

    @Override
    public final IllegalStateException propertyDoesNotMapToAnyRoot(String name, String location) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.propertyDoesNotMapToAnyRoot$str(), name, location));
        ConfigMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String couldNotGenerateMapping$str() {
        return "SRCFG00051: Could not generate ConfigMapping %s";
    }

    @Override
    public final IllegalStateException couldNotGenerateMapping(Throwable throwable, String mapping) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.couldNotGenerateMapping$str(), mapping), throwable);
        ConfigMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }
}

