/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.opentelemetry.implementation.rest;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.metrics.LongHistogram;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.InstrumenterBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerExperimentalMetrics;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerMetrics;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanStatusExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.network.NetworkAttributesExtractor;
import io.opentelemetry.instrumentation.api.internal.SemconvStability;
import io.opentelemetry.semconv.SemanticAttributes;
import io.smallrye.opentelemetry.api.OpenTelemetryConfig;
import jakarta.inject.Inject;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.ext.Provider;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;

@Provider
public class OpenTelemetryServerFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    private Instrumenter<ContainerRequestContext, ContainerResponseContext> instrumenter;
    private LongHistogram durationHistogram;
    @jakarta.ws.rs.core.Context
    ResourceInfo resourceInfo;

    public OpenTelemetryServerFilter() {
    }

    @Inject
    public OpenTelemetryServerFilter(OpenTelemetry openTelemetry) {
        HttpServerAttributesGetter serverAttributesGetter = new HttpServerAttributesGetter();
        InstrumenterBuilder builder = Instrumenter.builder((OpenTelemetry)openTelemetry, (String)"io.smallrye.opentelemetry", (SpanNameExtractor)HttpSpanNameExtractor.create((io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerAttributesGetter)serverAttributesGetter));
        builder.setInstrumentationVersion(OpenTelemetryConfig.INSTRUMENTATION_VERSION);
        this.instrumenter = builder.setSpanStatusExtractor(HttpSpanStatusExtractor.create((io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerAttributesGetter)serverAttributesGetter)).addAttributesExtractor((AttributesExtractor)NetworkAttributesExtractor.create((io.opentelemetry.instrumentation.api.instrumenter.network.NetworkAttributesGetter)new NetworkAttributesGetter())).addAttributesExtractor(HttpServerAttributesExtractor.create((io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerAttributesGetter)serverAttributesGetter)).addOperationMetrics(HttpServerMetrics.get()).addOperationMetrics(HttpServerExperimentalMetrics.get()).buildServerInstrumenter((TextMapGetter)new ContainerRequestContextTextMapGetter());
        Meter meter = openTelemetry.getMeter("io.smallrye.opentelemetry");
        this.durationHistogram = meter.histogramBuilder("http.server.duration").setDescription("The duration of the inbound HTTP request").ofLongs().setUnit("ms").build();
    }

    public void filter(ContainerRequestContext request) {
        Context parentContext;
        if (this.instrumenter != null && this.instrumenter.shouldStart(parentContext = Context.current(), (Object)request)) {
            request.setProperty("rest.resource.class", (Object)this.resourceInfo.getResourceClass());
            request.setProperty("rest.resource.method", (Object)this.resourceInfo.getResourceMethod());
            Context spanContext = this.instrumenter.start(parentContext, (Object)request);
            Scope scope = spanContext.makeCurrent();
            request.setProperty("otel.span.server.context", (Object)spanContext);
            request.setProperty("otel.span.server.parentContext", (Object)parentContext);
            request.setProperty("otel.span.server.scope", (Object)scope);
        }
        if (this.durationHistogram != null) {
            request.setProperty("otel.metrics.client.start", (Object)System.currentTimeMillis());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filter(ContainerRequestContext request, ContainerResponseContext response) {
        Long start;
        Context spanContext = (Context)request.getProperty("otel.span.server.context");
        if (this.instrumenter != null) {
            Scope scope = (Scope)request.getProperty("otel.span.server.scope");
            if (scope == null) {
                return;
            }
            try {
                this.instrumenter.end(spanContext, (Object)request, (Object)response, null);
            }
            finally {
                scope.close();
                request.removeProperty("rest.resource.class");
                request.removeProperty("rest.resource.method");
                request.removeProperty("otel.span.server.context");
                request.removeProperty("otel.span.server.parentContext");
                request.removeProperty("otel.span.server.scope");
            }
        }
        if (this.durationHistogram != null && (start = (Long)request.getProperty("otel.metrics.client.start")) != null) {
            try {
                this.durationHistogram.record(System.currentTimeMillis() - start, this.getHistogramAttributes(request, response), spanContext);
            }
            finally {
                request.removeProperty("otel.metrics.client.start");
            }
        }
    }

    private Attributes getHistogramAttributes(ContainerRequestContext request, ContainerResponseContext response) {
        AttributesBuilder builder = Attributes.builder();
        builder.put(SemanticAttributes.HTTP_ROUTE.getKey(), request.getUriInfo().getPath().toString());
        if (SemconvStability.emitOldHttpSemconv()) {
            builder.put(SemanticAttributes.HTTP_METHOD, (Object)request.getMethod());
            builder.put(SemanticAttributes.HTTP_STATUS_CODE, response.getStatus());
        } else {
            builder.put(SemanticAttributes.HTTP_REQUEST_METHOD, (Object)request.getMethod());
            builder.put(SemanticAttributes.HTTP_RESPONSE_STATUS_CODE, response.getStatus());
        }
        return builder.build();
    }

    private static class HttpServerAttributesGetter
    implements io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerAttributesGetter<ContainerRequestContext, ContainerResponseContext> {
        private HttpServerAttributesGetter() {
        }

        public String getUrlPath(ContainerRequestContext request) {
            return request.getUriInfo().getRequestUri().getPath();
        }

        public String getUrlQuery(ContainerRequestContext request) {
            return request.getUriInfo().getRequestUri().getQuery();
        }

        public String getHttpRoute(ContainerRequestContext request) {
            try {
                Class resource = (Class)request.getProperty("rest.resource.class");
                Method method = (Method)request.getProperty("rest.resource.method");
                UriBuilder uriBuilder = UriBuilder.newInstance();
                String contextRoot = request.getUriInfo().getBaseUri().getPath();
                if (contextRoot != null) {
                    uriBuilder.path(contextRoot);
                }
                uriBuilder.path(resource);
                if (method.isAnnotationPresent(Path.class)) {
                    uriBuilder.path(method);
                }
                return uriBuilder.toTemplate();
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }

        public String getUrlScheme(ContainerRequestContext request) {
            return request.getUriInfo().getRequestUri().getScheme();
        }

        public String getHttpRequestMethod(ContainerRequestContext request) {
            return request.getMethod();
        }

        public List<String> getHttpRequestHeader(ContainerRequestContext request, String name) {
            return (List)request.getHeaders().getOrDefault((Object)name, Collections.emptyList());
        }

        public Integer getHttpResponseStatusCode(ContainerRequestContext request, ContainerResponseContext response, Throwable throwable) {
            return response.getStatus();
        }

        public List<String> getHttpResponseHeader(ContainerRequestContext request, ContainerResponseContext response, String name) {
            return (List)response.getStringHeaders().getOrDefault((Object)name, Collections.emptyList());
        }
    }

    private static class NetworkAttributesGetter
    implements io.opentelemetry.instrumentation.api.instrumenter.network.NetworkAttributesGetter<ContainerRequestContext, ContainerResponseContext> {
        private NetworkAttributesGetter() {
        }

        public String getNetworkProtocolName(ContainerRequestContext request, ContainerResponseContext response) {
            return (String)request.getProperty(SemanticAttributes.NETWORK_PROTOCOL_NAME.getKey());
        }

        public String getNetworkProtocolVersion(ContainerRequestContext request, ContainerResponseContext response) {
            return (String)request.getProperty(SemanticAttributes.NETWORK_PROTOCOL_VERSION.getKey());
        }
    }

    private static class ContainerRequestContextTextMapGetter
    implements TextMapGetter<ContainerRequestContext> {
        private ContainerRequestContextTextMapGetter() {
        }

        public Iterable<String> keys(ContainerRequestContext carrier) {
            return carrier.getHeaders().keySet();
        }

        public String get(ContainerRequestContext carrier, String key) {
            if (carrier == null) {
                return null;
            }
            return (String)((List)carrier.getHeaders().getOrDefault((Object)key, Collections.singletonList(null))).get(0);
        }
    }
}

