/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.gryo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.tinkerpop.gremlin.process.remote.traversal.DefaultRemoteTraverser;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.PBiPredicate;
import org.apache.tinkerpop.gremlin.process.traversal.Path;
import org.apache.tinkerpop.gremlin.process.traversal.Text;
import org.apache.tinkerpop.gremlin.process.traversal.TextP;
import org.apache.tinkerpop.gremlin.process.traversal.util.AndP;
import org.apache.tinkerpop.gremlin.process.traversal.util.ConnectiveP;
import org.apache.tinkerpop.gremlin.process.traversal.util.OrP;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.io.gryo.kryoshim.InputShim;
import org.apache.tinkerpop.gremlin.structure.io.gryo.kryoshim.KryoShim;
import org.apache.tinkerpop.gremlin.structure.io.gryo.kryoshim.OutputShim;
import org.apache.tinkerpop.gremlin.structure.io.gryo.kryoshim.SerializerShim;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedFactory;
import org.apache.tinkerpop.gremlin.util.function.Lambda;

public final class GryoSerializersV1 {

    public static final class DefaultRemoteTraverserSerializer
    implements SerializerShim<DefaultRemoteTraverser> {
        @Override
        public <O extends OutputShim> void write(KryoShim<?, O> kryo, O output, DefaultRemoteTraverser remoteTraverser) {
            kryo.writeClassAndObject(output, remoteTraverser.get());
            output.writeLong(remoteTraverser.bulk());
        }

        @Override
        public <I extends InputShim> DefaultRemoteTraverser read(KryoShim<I, ?> kryo, I input, Class<DefaultRemoteTraverser> remoteTraverserClass) {
            Object o = kryo.readClassAndObject(input);
            return new DefaultRemoteTraverser<Object>(o, input.readLong());
        }
    }

    public static final class LambdaSerializer
    implements SerializerShim<Lambda> {
        @Override
        public <O extends OutputShim> void write(KryoShim<?, O> kryo, O output, Lambda lambda) {
            output.writeString(lambda.getLambdaScript());
            output.writeString(lambda.getLambdaLanguage());
            output.writeInt(lambda.getLambdaArguments());
        }

        @Override
        public <I extends InputShim> Lambda read(KryoShim<I, ?> kryo, I input, Class<Lambda> clazz) {
            String script = input.readString();
            String language = input.readString();
            int arguments = input.readInt();
            if (-1 == arguments || arguments > 2) {
                return new Lambda.UnknownArgLambda(script, language, arguments);
            }
            if (0 == arguments) {
                return new Lambda.ZeroArgLambda(script, language);
            }
            if (1 == arguments) {
                return new Lambda.OneArgLambda(script, language);
            }
            return new Lambda.TwoArgLambda(script, language);
        }
    }

    public static final class TextPSerializer
    implements SerializerShim<TextP> {
        @Override
        public <O extends OutputShim> void write(KryoShim<?, O> kryo, O output, TextP p) {
            PBiPredicate tp = p.getBiPredicate();
            if (tp instanceof Text) {
                output.writeString(((Text)tp).name());
            } else if (tp instanceof Text.RegexPredicate) {
                output.writeString(((Text.RegexPredicate)tp).isNegate() ? "notRegex" : "regex");
            } else {
                output.writeString(tp.toString());
            }
            kryo.writeObject(output, p.getValue());
        }

        @Override
        public <I extends InputShim> TextP read(KryoShim<I, ?> kryo, I input, Class<TextP> clazz) {
            String predicate = input.readString();
            String value = kryo.readObject(input, String.class);
            try {
                return (TextP)TextP.class.getMethod(predicate, String.class).invoke(null, value);
            }
            catch (Exception e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        }
    }

    public static final class PSerializer
    implements SerializerShim<P> {
        @Override
        public <O extends OutputShim> void write(KryoShim<?, O> kryo, O output, P p) {
            output.writeString(p instanceof ConnectiveP ? (p instanceof AndP ? "and" : "or") : p.getBiPredicate().toString());
            if (p instanceof ConnectiveP || p.getValue() instanceof Collection) {
                output.writeByte((byte)0);
                Collection<P<Object>> coll = p instanceof ConnectiveP ? ((ConnectiveP)p).getPredicates() : (Collection)p.getValue();
                output.writeInt(coll.size());
                coll.forEach(v -> kryo.writeClassAndObject(output, v));
            } else {
                output.writeByte((byte)1);
                kryo.writeClassAndObject(output, p.getValue());
            }
        }

        @Override
        public <I extends InputShim> P read(KryoShim<I, ?> kryo, I input, Class<P> clazz) {
            Object value;
            boolean isCollection;
            String predicate = input.readString();
            boolean bl = isCollection = input.readByte() == 0;
            if (isCollection) {
                value = new ArrayList();
                int size = input.readInt();
                for (int ix = 0; ix < size; ++ix) {
                    ((List)value).add(kryo.readClassAndObject(input));
                }
            } else {
                value = kryo.readClassAndObject(input);
            }
            try {
                if (predicate.equals("and") || predicate.equals("or")) {
                    return predicate.equals("and") ? new AndP((List)value) : new OrP((List)value);
                }
                if (value instanceof Collection) {
                    if (predicate.equals("between")) {
                        return P.between(((List)value).get(0), ((List)value).get(1));
                    }
                    if (predicate.equals("inside")) {
                        return P.inside(((List)value).get(0), ((List)value).get(1));
                    }
                    if (predicate.equals("outside")) {
                        return P.outside(((List)value).get(0), ((List)value).get(1));
                    }
                    if (predicate.equals("within")) {
                        return P.within((Collection)value);
                    }
                    if (predicate.equals("without")) {
                        return P.without((Collection)value);
                    }
                    return (P)P.class.getMethod(predicate, Collection.class).invoke(null, (Collection)value);
                }
                return (P)P.class.getMethod(predicate, Object.class).invoke(null, value);
            }
            catch (Exception e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        }
    }

    public static final class PathSerializer
    implements SerializerShim<Path> {
        @Override
        public <O extends OutputShim> void write(KryoShim<?, O> kryo, O output, Path path) {
            kryo.writeClassAndObject(output, DetachedFactory.detach(path, false));
        }

        @Override
        public <I extends InputShim> Path read(KryoShim<I, ?> kryo, I input, Class<Path> pathClass) {
            return (Path)kryo.readClassAndObject(input);
        }
    }

    public static final class VertexPropertySerializer
    implements SerializerShim<VertexProperty> {
        @Override
        public <O extends OutputShim> void write(KryoShim<?, O> kryo, O output, VertexProperty vertexProperty) {
            kryo.writeClassAndObject(output, DetachedFactory.detach(vertexProperty, true));
        }

        @Override
        public <I extends InputShim> VertexProperty read(KryoShim<I, ?> kryo, I input, Class<VertexProperty> vertexPropertyClass) {
            return (VertexProperty)kryo.readClassAndObject(input);
        }
    }

    public static final class PropertySerializer
    implements SerializerShim<Property> {
        @Override
        public <O extends OutputShim> void write(KryoShim<?, O> kryo, O output, Property property) {
            kryo.writeClassAndObject(output, property instanceof VertexProperty ? DetachedFactory.detach((VertexProperty)property, true) : DetachedFactory.detach(property));
        }

        @Override
        public <I extends InputShim> Property read(KryoShim<I, ?> kryo, I input, Class<Property> propertyClass) {
            return (Property)kryo.readClassAndObject(input);
        }
    }

    public static final class VertexSerializer
    implements SerializerShim<Vertex> {
        @Override
        public <O extends OutputShim> void write(KryoShim<?, O> kryo, O output, Vertex vertex) {
            kryo.writeClassAndObject(output, DetachedFactory.detach(vertex, true));
        }

        @Override
        public <I extends InputShim> Vertex read(KryoShim<I, ?> kryo, I input, Class<Vertex> vertexClass) {
            return (Vertex)kryo.readClassAndObject(input);
        }
    }

    public static final class EdgeSerializer
    implements SerializerShim<Edge> {
        @Override
        public <O extends OutputShim> void write(KryoShim<?, O> kryo, O output, Edge edge) {
            kryo.writeClassAndObject(output, DetachedFactory.detach(edge, true));
        }

        @Override
        public <I extends InputShim> Edge read(KryoShim<I, ?> kryo, I input, Class<Edge> edgeClass) {
            Object o = kryo.readClassAndObject(input);
            return (Edge)o;
        }
    }
}

