/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.binary.types;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.io.Buffer;
import org.apache.tinkerpop.gremlin.structure.io.binary.DataType;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.SimpleTypeSerializer;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedEdge;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedVertex;
import org.apache.tinkerpop.gremlin.structure.util.reference.ReferenceEdge;

public class EdgeSerializer
extends SimpleTypeSerializer<Edge> {
    public EdgeSerializer() {
        super(DataType.EDGE);
    }

    @Override
    protected Edge readValue(Buffer buffer, GraphBinaryReader context) throws IOException {
        Object id = context.read(buffer);
        String label = (String)context.readValue(buffer, List.class, false).get(0);
        Object inVId = context.read(buffer);
        String inVLabel = (String)context.readValue(buffer, List.class, false).get(0);
        Object outVId = context.read(buffer);
        String outVLabel = (String)context.readValue(buffer, List.class, false).get(0);
        context.read(buffer);
        List properties = (List)context.read(buffer);
        DetachedVertex inV = DetachedVertex.build().setId(inVId).setLabel(inVLabel).create();
        DetachedVertex outV = DetachedVertex.build().setId(outVId).setLabel(outVLabel).create();
        DetachedEdge.Builder builder = DetachedEdge.build().setId(id).setLabel(label).setInV(inV).setOutV(outV);
        if (properties != null) {
            for (Property p : properties) {
                builder.addProperty(p);
            }
        }
        return builder.create();
    }

    @Override
    protected void writeValue(Edge value, Buffer buffer, GraphBinaryWriter context) throws IOException {
        context.write(value.id(), buffer);
        if (value.label() == null) {
            throw new IOException("Unexpected null value when nullable is false");
        }
        context.writeValue(Collections.singletonList(value.label()), buffer, false);
        context.write(value.inVertex().id(), buffer);
        context.writeValue(Collections.singletonList(value.inVertex().label()), buffer, false);
        context.write(value.outVertex().id(), buffer);
        context.writeValue(Collections.singletonList(value.outVertex().label()), buffer, false);
        context.write(null, buffer);
        if (value instanceof ReferenceEdge) {
            context.write(null, buffer);
        } else {
            List asList = IteratorUtils.toList(value.properties(new String[0]));
            context.write(asList, buffer);
        }
    }
}

