/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.filter;

import java.io.Serializable;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BinaryOperator;
import org.apache.tinkerpop.gremlin.process.computer.MemoryComputeKey;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.Barrier;
import org.apache.tinkerpop.gremlin.process.traversal.step.Bypassing;
import org.apache.tinkerpop.gremlin.process.traversal.step.GValue;
import org.apache.tinkerpop.gremlin.process.traversal.step.Ranging;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.FilterStep;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.util.TraverserSet;
import org.apache.tinkerpop.gremlin.process.traversal.util.FastNoSuchElementException;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public final class RangeGlobalStep<S>
extends FilterStep<S>
implements Ranging,
Bypassing,
Barrier<TraverserSet<S>> {
    private GValue<Long> low;
    private final GValue<Long> high;
    private AtomicLong counter = new AtomicLong(0L);
    private boolean bypass;

    public RangeGlobalStep(Traversal.Admin traversal, long low, long high) {
        this(traversal, GValue.ofLong(null, low), GValue.ofLong(null, high));
    }

    public RangeGlobalStep(Traversal.Admin traversal, GValue<Long> low, GValue<Long> high) {
        super(traversal);
        if (low.get() != -1L && high.get() != -1L && low.get() > high.get()) {
            throw new IllegalArgumentException("Not a legal range: [" + low + ", " + high + ']');
        }
        this.low = low;
        this.high = high;
    }

    @Override
    protected boolean filter(Traverser.Admin<S> traverser) {
        if (this.bypass) {
            return true;
        }
        if (this.high.get() != -1L && this.counter.get() >= this.high.get()) {
            throw FastNoSuchElementException.instance();
        }
        long avail = traverser.bulk();
        if (this.counter.get() + avail <= this.low.get()) {
            this.counter.getAndAdd(avail);
            return false;
        }
        long toSkip = 0L;
        if (this.counter.get() < this.low.get()) {
            toSkip = this.low.get() - this.counter.get();
        }
        long toTrim = 0L;
        if (this.high.get() != -1L && this.counter.get() + avail >= this.high.get()) {
            toTrim = this.counter.get() + avail - this.high.get();
        }
        long toEmit = avail - toSkip - toTrim;
        this.counter.getAndAdd(toSkip + toEmit);
        traverser.setBulk(toEmit);
        return true;
    }

    @Override
    public void reset() {
        super.reset();
        this.counter.set(0L);
    }

    @Override
    public String toString() {
        return StringFactory.stepString(this, this.low.get(), this.high.get());
    }

    @Override
    public long getLowRange() {
        return this.low.get();
    }

    @Override
    public long getHighRange() {
        return this.high.get();
    }

    @Override
    public RangeGlobalStep<S> clone() {
        RangeGlobalStep clone = (RangeGlobalStep)super.clone();
        clone.counter = new AtomicLong(0L);
        return clone;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ Long.hashCode(this.low.get()) ^ Long.hashCode(this.high.get());
    }

    @Override
    public boolean equals(Object other) {
        if (super.equals(other)) {
            RangeGlobalStep typedOther = (RangeGlobalStep)other;
            return typedOther.low.get() == this.low.get() && typedOther.high.get() == this.high.get();
        }
        return false;
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return Collections.singleton(TraverserRequirement.BULK);
    }

    @Override
    public MemoryComputeKey<TraverserSet<S>> getMemoryComputeKey() {
        return MemoryComputeKey.of(this.getId(), new RangeBiOperator(this.high.get()), false, true);
    }

    @Override
    public void setBypass(boolean bypass) {
        this.bypass = bypass;
    }

    @Override
    public void processAllStarts() {
    }

    @Override
    public boolean hasNextBarrier() {
        return this.starts.hasNext();
    }

    @Override
    public TraverserSet<S> nextBarrier() throws NoSuchElementException {
        if (!this.starts.hasNext()) {
            throw FastNoSuchElementException.instance();
        }
        TraverserSet barrier = this.traversal.getTraverserSetSupplier().get();
        while (this.starts.hasNext()) {
            barrier.add(this.starts.next());
        }
        return barrier;
    }

    @Override
    public void addBarrier(TraverserSet<S> barrier) {
        IteratorUtils.removeOnNext(barrier.iterator()).forEachRemaining(traverser -> {
            traverser.setSideEffects(this.getTraversal().getSideEffects());
            this.addStart(traverser);
        });
    }

    public static final class RangeBiOperator<S>
    implements BinaryOperator<TraverserSet<S>>,
    Serializable {
        private final long highRange;

        public RangeBiOperator() {
            this(-1L);
        }

        public RangeBiOperator(long highRange) {
            this.highRange = highRange;
        }

        @Override
        public TraverserSet<S> apply(TraverserSet<S> mutatingSeed, TraverserSet<S> set) {
            if (this.highRange == -1L || (long)mutatingSeed.size() < this.highRange) {
                mutatingSeed.addAll(set);
            }
            return mutatingSeed;
        }
    }
}

