/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.simple;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.tinkerpop.gremlin.driver.Channelizer;
import org.apache.tinkerpop.gremlin.driver.handler.HttpContentDecompressionHandler;
import org.apache.tinkerpop.gremlin.driver.handler.HttpGremlinRequestEncoder;
import org.apache.tinkerpop.gremlin.driver.handler.HttpGremlinResponseStreamDecoder;
import org.apache.tinkerpop.gremlin.driver.interceptor.PayloadSerializingInterceptor;
import org.apache.tinkerpop.gremlin.driver.simple.AbstractClient;
import org.apache.tinkerpop.gremlin.util.MessageSerializer;
import org.apache.tinkerpop.gremlin.util.message.RequestMessage;
import org.apache.tinkerpop.gremlin.util.message.ResponseMessage;
import org.apache.tinkerpop.gremlin.util.ser.GraphBinaryMessageSerializerV4;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleHttpClient
extends AbstractClient {
    private static final Logger logger = LoggerFactory.getLogger(SimpleHttpClient.class);
    private final Channel channel;

    public SimpleHttpClient() {
        this(URI.create("http://localhost:8182/gremlin"));
    }

    public SimpleHttpClient(URI uri) {
        super("simple-http-client-%d");
        Bootstrap b = (Bootstrap)new Bootstrap().group(this.group);
        b.option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT);
        String protocol = uri.getScheme();
        if (!"http".equalsIgnoreCase(protocol) && !"https".equalsIgnoreCase(protocol)) {
            throw new IllegalArgumentException("Unsupported protocol: " + protocol);
        }
        final String host = uri.getHost();
        final int port = uri.getPort() == -1 ? ("http".equalsIgnoreCase(protocol) ? 80 : ("https".equalsIgnoreCase(protocol) ? 443 : -1)) : uri.getPort();
        try {
            boolean ssl = "https".equalsIgnoreCase(protocol);
            final SslContext sslCtx = ssl ? SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build() : null;
            GraphBinaryMessageSerializerV4 serializer = new GraphBinaryMessageSerializerV4();
            ((Bootstrap)b.channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>((MessageSerializer)serializer, uri){
                final /* synthetic */ MessageSerializer val$serializer;
                final /* synthetic */ URI val$uri;
                {
                    this.val$serializer = messageSerializer;
                    this.val$uri = uRI;
                }

                protected void initChannel(SocketChannel ch) {
                    ChannelPipeline p = ch.pipeline();
                    if (sslCtx != null) {
                        p.addLast(new ChannelHandler[]{sslCtx.newHandler(ch.alloc(), host, port)});
                    }
                    p.addLast(new ChannelHandler[]{new HttpClientCodec(), new HttpContentDecompressionHandler(), new HttpGremlinResponseStreamDecoder(this.val$serializer, Integer.MAX_VALUE), new HttpGremlinRequestEncoder(this.val$serializer, Collections.singletonList(Pair.of((Object)"serializer", (Object)new PayloadSerializingInterceptor((MessageSerializer)new GraphBinaryMessageSerializerV4()))), false, false, this.val$uri), SimpleHttpClient.this.callbackResponseHandler});
                }
            });
            this.channel = b.connect(uri.getHost(), uri.getPort()).sync().channel();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public CompletableFuture<List<ResponseMessage>> submitAsync(RequestMessage requestMessage) throws Exception {
        ArrayList results = new ArrayList();
        CompletableFuture<List<ResponseMessage>> f = new CompletableFuture<List<ResponseMessage>>();
        this.callbackResponseHandler.callback = response -> {
            if (f.isDone()) {
                throw new RuntimeException("A terminating message was already encountered - no more messages should have been received");
            }
            results.add(response);
            if (Channelizer.HttpChannelizer.LAST_CONTENT_READ_RESPONSE == response) {
                f.complete(results);
            }
        };
        this.writeAndFlush(requestMessage);
        return f;
    }

    @Override
    public void writeAndFlush(RequestMessage requestMessage) throws Exception {
        this.channel.writeAndFlush((Object)requestMessage);
    }

    @Override
    public void close() throws IOException {
        try {
            this.channel.close().get(30L, TimeUnit.SECONDS);
        }
        catch (Exception ex) {
            logger.error("Failure closing simple WebSocketClient", (Throwable)ex);
        }
        finally {
            if (!this.group.shutdownGracefully().awaitUninterruptibly(30L, TimeUnit.SECONDS)) {
                logger.error("Could not cleanly shutdown thread pool on WebSocketClient");
            }
        }
    }
}

