/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.DT;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.ScalarMapStep;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

public final class DateAddStep<S>
extends ScalarMapStep<S, OffsetDateTime> {
    private DT dateToken;
    private int value;

    public DateAddStep(Traversal.Admin traversal, DT dateToken, int value) {
        super(traversal);
        this.dateToken = dateToken;
        this.value = value;
    }

    @Override
    protected OffsetDateTime map(Traverser.Admin<S> traverser) {
        OffsetDateTime new_date;
        Object object = traverser.get();
        if (!(object instanceof OffsetDateTime)) {
            throw new IllegalArgumentException("dateAdd accept only DateTime.");
        }
        OffsetDateTime date = (OffsetDateTime)object;
        switch (this.dateToken) {
            case second: {
                new_date = date.plus(Duration.ofSeconds(this.value));
                break;
            }
            case minute: {
                new_date = date.plus(Duration.ofMinutes(this.value));
                break;
            }
            case hour: {
                new_date = date.plus(Duration.ofHours(this.value));
                break;
            }
            case day: {
                new_date = date.plus(Duration.ofDays(this.value));
                break;
            }
            default: {
                throw new IllegalArgumentException("DT tokens should only be second, minute, hour, or day.");
            }
        }
        return new_date;
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return Collections.singleton(TraverserRequirement.OBJECT);
    }

    @Override
    public void setTraversal(Traversal.Admin<?, ?> parentTraversal) {
        super.setTraversal(parentTraversal);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.dateToken.hashCode();
        result = 31 * result + this.value;
        return result;
    }

    @Override
    public DateAddStep<S> clone() {
        DateAddStep clone = (DateAddStep)super.clone();
        clone.value = this.value;
        clone.dateToken = this.dateToken;
        return clone;
    }

    @Override
    public String toString() {
        return StringFactory.stepString(this, new Object[0]);
    }

    public DT getDateToken() {
        return this.dateToken;
    }

    public int getValue() {
        return this.value;
    }
}

