/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalSideEffects;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.TraverserGenerator;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.EmptyStep;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;

public interface Failure {
    public String getMessage();

    public Map<String, Object> getMetadata();

    public Traverser.Admin getTraverser();

    public Traversal.Admin getTraversal();

    default public String format() {
        ArrayList<String> lines = new ArrayList<String>();
        Step parentStep = (Step)((Object)this.getTraversal().getParent());
        lines.add(String.format("Message  > %s", this.getMessage()));
        lines.add(String.format("Traverser> %s", this.getTraverser().toString()));
        TraverserGenerator generator = this.getTraversal().getTraverserGenerator();
        Traverser.Admin traverser = this.getTraverser();
        if (generator.getProvidedRequirements().contains((Object)TraverserRequirement.BULK)) {
            lines.add(String.format("  Bulk   > %s", traverser.bulk()));
        }
        if (generator.getProvidedRequirements().contains((Object)TraverserRequirement.SACK)) {
            lines.add(String.format("  Sack   > %s", traverser.sack()));
        }
        if (generator.getProvidedRequirements().contains((Object)TraverserRequirement.PATH)) {
            lines.add(String.format("  Path   > %s", traverser.path()));
        }
        if (generator.getProvidedRequirements().contains((Object)TraverserRequirement.SINGLE_LOOP) || generator.getProvidedRequirements().contains((Object)TraverserRequirement.NESTED_LOOP)) {
            Set<String> loopNames = traverser.getLoopNames();
            String loopsLine = loopNames.isEmpty() ? String.valueOf(traverser.asAdmin().loops()) : loopNames.stream().collect(Collectors.toMap(loopName -> loopName, traverser::loops)).toString();
            lines.add(String.format("  Loops  > %s", loopsLine));
        }
        if (generator.getProvidedRequirements().contains((Object)TraverserRequirement.SIDE_EFFECTS)) {
            TraversalSideEffects tse = traverser.getSideEffects();
            Set<String> keys = tse.keys();
            Object[] objectArray = new Object[1];
            objectArray[0] = keys.stream().collect(Collectors.toMap(k -> k, tse::get));
            lines.add(String.format("  S/E    > %s", objectArray));
        }
        lines.add(String.format("Traversal> %s", this.getTraversal().getGremlinLang().getGremlin().substring(1)));
        if (parentStep != EmptyStep.instance()) {
            lines.add(String.format("Parent   > %s [%s]", parentStep.getClass().getSimpleName(), this.getTraversal().getGremlinLang().getGremlin().substring(1)));
        }
        lines.add(String.format("Metadata > %s", this.getMetadata()));
        int longestLineLength = lines.stream().mapToInt(String::length).max().getAsInt();
        String separatorLine = String.join((CharSequence)"", Collections.nCopies(longestLineLength, "="));
        lines.add(0, separatorLine);
        lines.add(0, "fail() Step Triggered");
        lines.add(separatorLine);
        return String.join((CharSequence)System.lineSeparator(), lines);
    }
}

