"use strict";
/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 */
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.structure = exports.process = exports.driver = void 0;
/**
 * @author Jorge Bay Gondra
 */
const t = __importStar(require("./process/traversal.cjs"));
const gt = __importStar(require("./process/graph-traversal.cjs"));
const strategiesModule = __importStar(require("./process/traversal-strategy.cjs"));
const graph = __importStar(require("./structure/graph.cjs"));
const gs = __importStar(require("./structure/io/graph-serializer.cjs"));
const rc = __importStar(require("./driver/remote-connection.cjs"));
const bytecode_js_1 = __importDefault(require("./process/bytecode.cjs"));
const translator_js_1 = __importDefault(require("./process/translator.cjs"));
const utils = __importStar(require("./utils.cjs"));
const driver_remote_connection_js_1 = __importDefault(require("./driver/driver-remote-connection.cjs"));
const response_error_js_1 = __importDefault(require("./driver/response-error.cjs"));
const client_js_1 = __importDefault(require("./driver/client.cjs"));
const result_set_js_1 = __importDefault(require("./driver/result-set.cjs"));
const authenticator_js_1 = __importDefault(require("./driver/auth/authenticator.cjs"));
const plain_text_sasl_authenticator_js_1 = __importDefault(require("./driver/auth/plain-text-sasl-authenticator.cjs"));
const anonymous_traversal_js_1 = __importDefault(require("./process/anonymous-traversal.cjs"));
exports.driver = {
    RemoteConnection: rc.RemoteConnection,
    RemoteStrategy: rc.RemoteStrategy,
    RemoteTraversal: rc.RemoteTraversal,
    ResponseError: response_error_js_1.default,
    DriverRemoteConnection: driver_remote_connection_js_1.default,
    Client: client_js_1.default,
    ResultSet: result_set_js_1.default,
    auth: {
        Authenticator: authenticator_js_1.default,
        PlainTextSaslAuthenticator: plain_text_sasl_authenticator_js_1.default,
    },
};
exports.process = {
    Bytecode: bytecode_js_1.default,
    EnumValue: t.EnumValue,
    P: t.P,
    TextP: t.TextP,
    Traversal: t.Traversal,
    TraversalSideEffects: t.TraversalSideEffects,
    TraversalStrategies: strategiesModule.TraversalStrategies,
    TraversalStrategy: strategiesModule.TraversalStrategy,
    Traverser: t.Traverser,
    barrier: t.barrier,
    cardinality: t.cardinality,
    column: t.column,
    direction: t.direction,
    dt: t.dt,
    merge: t.merge,
    operator: t.operator,
    order: t.order,
    pick: t.pick,
    pop: t.pop,
    scope: t.scope,
    t: t.t,
    GraphTraversal: gt.GraphTraversal,
    GraphTraversalSource: gt.GraphTraversalSource,
    statics: gt.statics,
    Translator: translator_js_1.default,
    traversal: anonymous_traversal_js_1.default.traversal,
    AnonymousTraversalSource: anonymous_traversal_js_1.default,
    withOptions: t.withOptions,
};
exports.structure = {
    io: gs,
    Edge: graph.Edge,
    Graph: graph.Graph,
    Path: graph.Path,
    Property: graph.Property,
    Vertex: graph.Vertex,
    VertexProperty: graph.VertexProperty,
    toLong: utils.toLong,
};
