/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.gryo;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.io.GraphWriter;
import org.apache.tinkerpop.gremlin.structure.io.Mapper;
import org.apache.tinkerpop.gremlin.structure.io.gryo.GryoMapper;
import org.apache.tinkerpop.gremlin.structure.io.gryo.VertexTerminator;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedFactory;
import org.apache.tinkerpop.gremlin.structure.util.star.StarGraph;
import org.apache.tinkerpop.gremlin.structure.util.star.StarGraphGryoSerializer;
import org.apache.tinkerpop.shaded.kryo.Kryo;
import org.apache.tinkerpop.shaded.kryo.Serializer;
import org.apache.tinkerpop.shaded.kryo.io.Output;

public final class GryoWriter
implements GraphWriter {
    private Kryo kryo;

    private GryoWriter(Mapper<Kryo> gryoMapper) {
        this.kryo = gryoMapper.createMapper();
    }

    @Override
    public void writeGraph(OutputStream outputStream, Graph g) throws IOException {
        this.writeVertices(outputStream, g.vertices(new Object[0]), Direction.BOTH);
    }

    @Override
    public void writeVertices(OutputStream outputStream, Iterator<Vertex> vertexIterator, Direction direction) throws IOException {
        this.kryo.getRegistration(StarGraph.class).setSerializer((Serializer)StarGraphGryoSerializer.with(direction));
        Output output = new Output(outputStream);
        while (vertexIterator.hasNext()) {
            this.writeVertexInternal(output, vertexIterator.next());
        }
        output.flush();
        this.kryo.getRegistration(StarGraph.class).setSerializer((Serializer)StarGraphGryoSerializer.with(Direction.BOTH));
    }

    @Override
    public void writeVertices(OutputStream outputStream, Iterator<Vertex> vertexIterator) throws IOException {
        this.writeVertices(outputStream, vertexIterator, null);
    }

    @Override
    public void writeVertex(OutputStream outputStream, Vertex v, Direction direction) throws IOException {
        this.kryo.getRegistration(StarGraph.class).setSerializer((Serializer)StarGraphGryoSerializer.with(direction));
        Output output = new Output(outputStream);
        this.writeVertexInternal(output, v);
        output.flush();
        this.kryo.getRegistration(StarGraph.class).setSerializer((Serializer)StarGraphGryoSerializer.with(Direction.BOTH));
    }

    @Override
    public void writeVertex(OutputStream outputStream, Vertex v) throws IOException {
        this.writeVertex(outputStream, v, null);
    }

    @Override
    public void writeEdge(OutputStream outputStream, Edge e) throws IOException {
        Output output = new Output(outputStream);
        this.writeHeader(output);
        this.kryo.writeObject(output, (Object)DetachedFactory.detach(e, true));
        output.flush();
    }

    @Override
    public void writeVertexProperty(OutputStream outputStream, VertexProperty vp) throws IOException {
        Output output = new Output(outputStream);
        this.writeHeader(output);
        this.kryo.writeObject(output, (Object)DetachedFactory.detach(vp, true));
        output.flush();
    }

    @Override
    public void writeProperty(OutputStream outputStream, Property p) throws IOException {
        Output output = new Output(outputStream);
        this.writeHeader(output);
        this.kryo.writeObject(output, DetachedFactory.detach(p, true));
        output.flush();
    }

    @Override
    public void writeObject(OutputStream outputStream, Object object) {
        Output output = new Output(outputStream);
        this.kryo.writeClassAndObject(output, object);
        output.flush();
    }

    void writeVertexInternal(Output output, Vertex v) throws IOException {
        this.writeHeader(output);
        this.kryo.writeObject(output, (Object)StarGraph.of(v));
        this.kryo.writeClassAndObject(output, (Object)VertexTerminator.INSTANCE);
    }

    void writeHeader(Output output) throws IOException {
        output.writeBytes(GryoMapper.HEADER);
    }

    public static Builder build() {
        return new Builder();
    }

    public static final class Builder
    implements GraphWriter.WriterBuilder<GryoWriter> {
        private Mapper<Kryo> gryoMapper = GryoMapper.build().create();

        private Builder() {
        }

        public Builder mapper(Mapper<Kryo> gryoMapper) {
            this.gryoMapper = gryoMapper;
            return this;
        }

        @Override
        public GryoWriter create() {
            return new GryoWriter(this.gryoMapper);
        }
    }
}

