/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure;

import java.util.Iterator;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public interface Edge
extends Element {
    public static final String DEFAULT_LABEL = "edge";

    public Iterator<Vertex> vertices(Direction var1);

    default public Vertex outVertex() {
        return this.vertices(Direction.OUT).next();
    }

    default public Vertex inVertex() {
        return this.vertices(Direction.IN).next();
    }

    default public Iterator<Vertex> bothVertices() {
        return this.vertices(Direction.BOTH);
    }

    public <V> Iterator<Property<V>> properties(String ... var1);

    public static class Exceptions
    extends Element.Exceptions {
        private Exceptions() {
        }

        public static UnsupportedOperationException userSuppliedIdsNotSupported() {
            return new UnsupportedOperationException("Edge does not support user supplied identifiers");
        }

        public static UnsupportedOperationException userSuppliedIdsOfThisTypeNotSupported() {
            return new UnsupportedOperationException("Edge does not support user supplied identifiers of this type");
        }

        public static IllegalStateException edgeRemovalNotSupported() {
            return new IllegalStateException("Edge removal are not supported");
        }
    }
}

