/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.tinkerpop.gremlin.server.util;

import org.apache.commons.lang3.concurrent.BasicThreadFactory;

import java.util.concurrent.ThreadFactory;

/**
 * @author Stephen Mallette (http://stephen.genoprime.com)
 */
public final class ThreadFactoryUtil {
    private static final String SERVER_THREAD_PREFIX = "gremlin-server-";
    private ThreadFactoryUtil() {}

    public static ThreadFactory create(final String pattern) {
        return new BasicThreadFactory.Builder().namingPattern(SERVER_THREAD_PREFIX + pattern).build();
    }
}
