/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.transform;

import java.util.List;
import org.apache.tapestry5.annotations.Log;
import org.apache.tapestry5.ioc.internal.services.LoggingAdvice;
import org.apache.tapestry5.ioc.services.ExceptionTracker;
import org.apache.tapestry5.model.MutableComponentModel;
import org.apache.tapestry5.plastic.MethodAdvice;
import org.apache.tapestry5.plastic.PlasticClass;
import org.apache.tapestry5.plastic.PlasticMethod;
import org.apache.tapestry5.services.transform.ComponentClassTransformWorker2;
import org.apache.tapestry5.services.transform.TransformationSupport;

public class LogWorker
implements ComponentClassTransformWorker2 {
    private final ExceptionTracker exceptionTracker;

    public LogWorker(ExceptionTracker exceptionTracker) {
        this.exceptionTracker = exceptionTracker;
    }

    @Override
    public void transform(PlasticClass plasticClass, TransformationSupport support, MutableComponentModel model) {
        List methods = plasticClass.getMethodsWithAnnotation(Log.class);
        if (methods.isEmpty()) {
            return;
        }
        LoggingAdvice loggingAdvice = new LoggingAdvice(model.getLogger(), this.exceptionTracker);
        for (PlasticMethod method : methods) {
            method.addAdvice((MethodAdvice)loggingAdvice);
        }
    }
}

