/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.corelib.mixins;

import org.apache.tapestry5.Field;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.ValidationDecorator;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.annotations.HeartbeatDeferred;
import org.apache.tapestry5.annotations.InjectContainer;
import org.apache.tapestry5.dom.Element;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;

public class FormGroup {
    @InjectContainer
    private Field field;
    @Inject
    @Symbol(value="tapestry.form-group-label-css-class")
    private String labelCssClass;
    @Inject
    @Symbol(value="tapestry.form-group-wrapper-css-class")
    private String divCssClass;
    @Inject
    @Symbol(value="tapestry.form-group-form-field-wrapper-element-name")
    private String fieldWrapperElementName;
    @Inject
    @Symbol(value="tapestry.form-group-form-field-wrapper-element-css-class")
    private String fieldWrapperElementCssClass;
    private Element label;
    private Element fieldWrapper;
    @Environmental
    private ValidationDecorator decorator;
    @Inject
    private JavaScriptSupport javaScriptSupport;

    void beginRender(MarkupWriter writer) {
        writer.element("div", "class", !"form-group".equals(this.divCssClass) ? "form-group " + this.divCssClass : this.divCssClass);
        this.decorator.beforeLabel(this.field);
        this.label = writer.element("label", "class", this.labelCssClass);
        writer.end();
        this.fillInLabelAttributes();
        this.decorator.afterLabel(this.field);
        if (this.fieldWrapperElementName.length() > 0) {
            this.fieldWrapper = writer.element(this.fieldWrapperElementName, new Object[0]);
            if (this.fieldWrapperElementCssClass.length() > 0) {
                this.fieldWrapper.attribute("class", this.fieldWrapperElementCssClass);
            }
        }
    }

    @HeartbeatDeferred
    void fillInLabelAttributes() {
        this.label.attribute("for", this.field.getClientId());
        this.label.text(this.field.getLabel());
    }

    void afterRender(MarkupWriter writer) {
        Element inputElement;
        if (this.fieldWrapper != null) {
            writer.end();
        }
        if ((inputElement = writer.getDocument().getElementById(this.field.getClientId())) != null) {
            String clientId = this.field.getClientId();
            String labelId = this.javaScriptSupport.allocateClientId(clientId + "-label");
            this.label.attribute("id", labelId);
            inputElement.attribute("aria-labelledby", labelId);
        }
        writer.end();
    }
}

