/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.hibernate;

import java.util.List;
import org.apache.tapestry5.grid.GridDataSource;
import org.apache.tapestry5.grid.SortConstraint;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;

public class HibernateGridDataSource
implements GridDataSource {
    private final Session session;
    private final Class entityType;
    private int startIndex;
    private List preparedResults;

    public HibernateGridDataSource(Session session, Class entityType) {
        assert (session != null);
        assert (entityType != null);
        this.session = session;
        this.entityType = entityType;
    }

    public int getAvailableRows() {
        Criteria criteria = this.session.createCriteria(this.entityType);
        this.applyAdditionalConstraints(criteria);
        criteria.setProjection(Projections.rowCount());
        Number result = (Number)criteria.uniqueResult();
        return result.intValue();
    }

    public void prepare(int startIndex, int endIndex, List<SortConstraint> sortConstraints) {
        assert (sortConstraints != null);
        Criteria crit = this.session.createCriteria(this.entityType);
        crit.setFirstResult(startIndex).setMaxResults(endIndex - startIndex + 1);
        for (SortConstraint constraint : sortConstraints) {
            String propertyName = constraint.getPropertyModel().getPropertyName();
            switch (constraint.getColumnSort()) {
                case ASCENDING: {
                    crit.addOrder(Order.asc((String)propertyName));
                    break;
                }
                case DESCENDING: {
                    crit.addOrder(Order.desc((String)propertyName));
                    break;
                }
            }
        }
        this.applyAdditionalConstraints(crit);
        this.startIndex = startIndex;
        this.preparedResults = crit.list();
    }

    protected void applyAdditionalConstraints(Criteria crit) {
    }

    public Object getRowValue(int index) {
        return this.preparedResults.get(index - this.startIndex);
    }

    public Class getRowType() {
        return this.entityType;
    }
}

