/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup.mapping;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.sysds.runtime.compress.colgroup.IMapToDataGroup;
import org.apache.sysds.runtime.compress.colgroup.dictionary.IDictionary;
import org.apache.sysds.runtime.compress.colgroup.indexes.IColIndex;
import org.apache.sysds.runtime.compress.colgroup.mapping.AMapToData;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToBit;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToByte;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToFactory;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToUByte;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToZero;
import org.apache.sysds.runtime.data.DenseBlock;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.io.IOUtilFunctions;
import org.apache.sysds.utils.MemoryEstimates;

public class MapToChar
extends AMapToData {
    private static final long serialVersionUID = 6315708056775476541L;
    private final char[] _data;

    protected MapToChar(int size) {
        this(65536, size);
    }

    public MapToChar(int unique, int size) {
        super(Math.min(unique, 65536));
        this._data = new char[size];
    }

    public MapToChar(int unique, char[] data) {
        super(unique);
        this._data = data;
        this.verify();
    }

    @Override
    public MapToFactory.MAP_TYPE getType() {
        return MapToFactory.MAP_TYPE.CHAR;
    }

    @Override
    public int getIndex(int n) {
        return this._data[n];
    }

    @Override
    public void fill(int v) {
        Arrays.fill(this._data, (char)v);
    }

    @Override
    public long getInMemorySize() {
        return MapToChar.getInMemorySize(this._data.length);
    }

    public static long getInMemorySize(int dataLength) {
        long size = 24L;
        size = (long)((double)size + MemoryEstimates.charArrayCost(dataLength));
        return size;
    }

    @Override
    public long getExactSizeOnDisk() {
        return 9 + this._data.length * 2;
    }

    @Override
    public void set(int n, int v) {
        this._data[n] = (char)v;
    }

    @Override
    public void set(int l, int u, int off, AMapToData tm) {
        if (tm instanceof MapToChar) {
            MapToChar tbm = (MapToChar)tm;
            char[] tbv = tbm._data;
            int i = l;
            while (i < u) {
                this._data[i] = tbv[off];
                ++i;
                ++off;
            }
        } else {
            int i = l;
            while (i < u) {
                this.set(i, tm.getIndex(off));
                ++i;
                ++off;
            }
        }
    }

    @Override
    public int setAndGet(int n, int v) {
        this._data[n] = (char)v;
        return this._data[n];
    }

    @Override
    public int size() {
        return this._data.length;
    }

    @Override
    public void replace(int v, int r) {
        char cv = (char)v;
        char rv = (char)r;
        for (int i = 0; i < this.size(); ++i) {
            if (this._data[i] != cv) continue;
            this._data[i] = rv;
        }
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeByte(MapToFactory.MAP_TYPE.CHAR.ordinal());
        out.writeInt(this.getUnique());
        out.writeInt(this._data.length);
        MapToChar.writeChars(out, this._data);
    }

    protected static void writeChars(DataOutput out, char[] _data_c) throws IOException {
        int BS = 100;
        if (_data_c.length > 100) {
            byte[] buff = new byte[200];
            int i = 0;
            while (i < _data_c.length) {
                i = MapToChar.writeCharsBlock(out, _data_c, 100, buff, i);
            }
        } else {
            for (int i = 0; i < _data_c.length; ++i) {
                out.writeChar(_data_c[i]);
            }
        }
    }

    private static int writeCharsBlock(DataOutput out, char[] _data_c, int BS, byte[] buff, int i) throws IOException {
        if (i + BS <= _data_c.length) {
            for (int o = 0; o < BS; ++o) {
                IOUtilFunctions.shortToBa(_data_c[i++], buff, o * 2);
            }
            out.write(buff);
        } else {
            while (i < _data_c.length) {
                out.writeChar(_data_c[i]);
                ++i;
            }
        }
        return i;
    }

    protected static MapToChar readFields(DataInput in) throws IOException {
        int unique = in.readInt();
        int length = in.readInt();
        char[] data = new char[length];
        for (int i = 0; i < length; ++i) {
            data[i] = (char)in.readUnsignedShort();
        }
        return new MapToChar(unique, data);
    }

    @Override
    protected void preAggregateDenseToRowBy8(double[] mV, double[] preAV, int cl, int cu, int off) {
        int h = (cu - cl) % 8;
        off += cl;
        int rc = cl;
        while (rc < cl + h) {
            int n = this.getIndex(rc);
            preAV[n] = preAV[n] + mV[off];
            ++rc;
            ++off;
        }
        rc = cl + h;
        while (rc < cu) {
            this.preAggregateDenseToRowVec8(mV, preAV, rc, off);
            rc += 8;
            off += 8;
        }
    }

    @Override
    protected void preAggregateDenseToRowVec8(double[] mV, double[] preAV, int rc, int off) {
        int n = this.getIndex(rc);
        preAV[n] = preAV[n] + mV[off];
        int n2 = this.getIndex(rc + 1);
        preAV[n2] = preAV[n2] + mV[off + 1];
        int n3 = this.getIndex(rc + 2);
        preAV[n3] = preAV[n3] + mV[off + 2];
        int n4 = this.getIndex(rc + 3);
        preAV[n4] = preAV[n4] + mV[off + 3];
        int n5 = this.getIndex(rc + 4);
        preAV[n5] = preAV[n5] + mV[off + 4];
        int n6 = this.getIndex(rc + 5);
        preAV[n6] = preAV[n6] + mV[off + 5];
        int n7 = this.getIndex(rc + 6);
        preAV[n7] = preAV[n7] + mV[off + 6];
        int n8 = this.getIndex(rc + 7);
        preAV[n8] = preAV[n8] + mV[off + 7];
    }

    @Override
    protected void preAggregateDenseMultiRowContiguousBy8(double[] mV, int nCol, int nVal, double[] preAV, int rl, int ru, int cl, int cu) {
        int h = (cu - cl) % 8;
        this.preAggregateDenseMultiRowContiguousBy1(mV, nCol, nVal, preAV, rl, ru, cl, cl + h);
        int offR = nCol * rl;
        int offE = nCol * ru;
        for (int c = cl + h; c < cu; c += 8) {
            char id1 = this._data[c];
            char id2 = this._data[c + 1];
            char id3 = this._data[c + 2];
            char id4 = this._data[c + 3];
            char id5 = this._data[c + 4];
            char id6 = this._data[c + 5];
            char id7 = this._data[c + 6];
            char id8 = this._data[c + 7];
            int start = c + offR;
            int end = c + offE;
            int nValOff = 0;
            for (int off = start; off < end; off += nCol) {
                int n = id1 + nValOff;
                preAV[n] = preAV[n] + mV[off];
                int n2 = id2 + nValOff;
                preAV[n2] = preAV[n2] + mV[off + 1];
                int n3 = id3 + nValOff;
                preAV[n3] = preAV[n3] + mV[off + 2];
                int n4 = id4 + nValOff;
                preAV[n4] = preAV[n4] + mV[off + 3];
                int n5 = id5 + nValOff;
                preAV[n5] = preAV[n5] + mV[off + 4];
                int n6 = id6 + nValOff;
                preAV[n6] = preAV[n6] + mV[off + 5];
                int n7 = id7 + nValOff;
                preAV[n7] = preAV[n7] + mV[off + 6];
                int n8 = id8 + nValOff;
                preAV[n8] = preAV[n8] + mV[off + 7];
                nValOff += nVal;
            }
        }
    }

    @Override
    public int getUpperBoundValue() {
        return 65535;
    }

    @Override
    public void copyInt(int[] d, int start, int end) {
        for (int i = start; i < end; ++i) {
            this._data[i] = (char)d[i];
        }
    }

    @Override
    public int[] getCounts(int[] ret) {
        int h = this._data.length % 8;
        for (int i = 0; i < h; ++i) {
            int n = this.getIndex(i);
            ret[n] = ret[n] + 1;
        }
        this.getCountsBy8P(ret, h, this._data.length);
        return ret;
    }

    private void getCountsBy8P(int[] ret, int s, int e) {
        for (int i = s; i < e; i += 8) {
            int n = this.getIndex(i);
            ret[n] = ret[n] + 1;
            int n2 = this.getIndex(i + 1);
            ret[n2] = ret[n2] + 1;
            int n3 = this.getIndex(i + 2);
            ret[n3] = ret[n3] + 1;
            int n4 = this.getIndex(i + 3);
            ret[n4] = ret[n4] + 1;
            int n5 = this.getIndex(i + 4);
            ret[n5] = ret[n5] + 1;
            int n6 = this.getIndex(i + 5);
            ret[n6] = ret[n6] + 1;
            int n7 = this.getIndex(i + 6);
            ret[n7] = ret[n7] + 1;
            int n8 = this.getIndex(i + 7);
            ret[n8] = ret[n8] + 1;
        }
    }

    @Override
    public AMapToData resize(int unique) {
        AMapToData ret;
        int size = this._data.length;
        if (unique <= 1) {
            return new MapToZero(size);
        }
        if (unique == 2 && size > 32) {
            ret = new MapToBit(unique, size);
        } else if (unique <= 127) {
            ret = new MapToUByte(unique, size);
        } else if (unique < 256) {
            ret = new MapToByte(unique, size);
        } else {
            this.setUnique(unique);
            return this;
        }
        ret.copy(this);
        return ret;
    }

    @Override
    public int countRuns() {
        int c = 1;
        char prev = this._data[0];
        for (int i = 1; i < this._data.length; ++i) {
            c += prev == this._data[i] ? 0 : 1;
            prev = this._data[i];
        }
        return c;
    }

    @Override
    public AMapToData slice(int l, int u) {
        return new MapToChar(this.getUnique(), Arrays.copyOfRange(this._data, l, u));
    }

    @Override
    public AMapToData append(AMapToData t) {
        if (t instanceof MapToChar) {
            MapToChar tb = (MapToChar)t;
            char[] tbb = tb._data;
            int newSize = this._data.length + t.size();
            int newDistinct = Math.max(this.getUnique(), t.getUnique());
            char[] ret = Arrays.copyOf(this._data, newSize);
            System.arraycopy(tbb, 0, ret, this._data.length, t.size());
            return new MapToChar(newDistinct, ret);
        }
        throw new NotImplementedException("Not implemented append on Bit map different type");
    }

    @Override
    public AMapToData appendN(IMapToDataGroup[] d) {
        int p = 0;
        for (IMapToDataGroup gd : d) {
            p += gd.getMapToData().size();
        }
        char[] ret = new char[p];
        p = 0;
        for (int i = 0; i < d.length; ++i) {
            if (d[i].getMapToData().size() <= 0) continue;
            MapToChar mm = (MapToChar)d[i].getMapToData();
            int ms = mm.size();
            System.arraycopy(mm._data, 0, ret, p, ms);
            p += ms;
        }
        return new MapToChar(this.getUnique(), ret);
    }

    @Override
    public boolean equals(AMapToData e) {
        return e instanceof MapToChar && e.getUnique() == this.getUnique() && Arrays.equals(((MapToChar)e)._data, this._data);
    }

    @Override
    protected void preAggregateDDC_DDCSingleCol_vec(AMapToData tm, double[] td, double[] v, int r) {
        if (tm instanceof MapToChar) {
            this.preAggregateDDC_DDCSingleCol_vecChar((MapToChar)tm, td, v, r);
        } else {
            super.preAggregateDDC_DDCSingleCol_vec(tm, td, v, r);
        }
    }

    @Override
    public void lmSparseMatrixRow(SparseBlock sb, int r, DenseBlock db, IColIndex colIndexes, IDictionary dict) {
        if (sb.isEmpty(r)) {
            return;
        }
        int pos = db.pos(r);
        double[] retV = db.values(r);
        int apos = sb.pos(r);
        int alen = sb.size(r) + apos;
        int[] aix = sb.indexes(r);
        double[] aval = sb.values(r);
        for (int i = apos; i < alen; ++i) {
            dict.multiplyScalar(aval[i], retV, pos, this.getIndex(aix[i]), colIndexes);
        }
    }

    @Override
    public void decompressToRange(double[] c, int rl, int ru, int offR, double[] values) {
        if (offR == 0) {
            this.decompressToRangeNoOff(c, rl, ru, values);
        } else {
            this.decompressToRangeOff(c, rl, ru, offR, values);
        }
    }

    @Override
    public void decompressToRangeOff(double[] c, int rl, int ru, int offR, double[] values) {
        int offT = rl + offR;
        for (int i = rl; i < ru; ++i) {
            int n = offT++;
            c[n] = c[n] + values[this.getIndex(i)];
        }
    }

    @Override
    public void decompressToRangeNoOff(double[] c, int rl, int ru, double[] values) {
        int rc;
        int h = (ru - rl) % 8;
        for (rc = rl; rc < rl + h; ++rc) {
            int n = rc;
            c[n] = c[n] + values[this.getIndex(rc)];
        }
        for (rc = rl + h; rc < ru; rc += 8) {
            this.decompressToRangeNoOffBy8(c, rc, values);
        }
    }

    @Override
    protected void decompressToRangeNoOffBy8(double[] c, int r, double[] values) {
        int n = r;
        c[n] = c[n] + values[this.getIndex(r)];
        int n2 = r + 1;
        c[n2] = c[n2] + values[this.getIndex(r + 1)];
        int n3 = r + 2;
        c[n3] = c[n3] + values[this.getIndex(r + 2)];
        int n4 = r + 3;
        c[n4] = c[n4] + values[this.getIndex(r + 3)];
        int n5 = r + 4;
        c[n5] = c[n5] + values[this.getIndex(r + 4)];
        int n6 = r + 5;
        c[n6] = c[n6] + values[this.getIndex(r + 5)];
        int n7 = r + 6;
        c[n7] = c[n7] + values[this.getIndex(r + 6)];
        int n8 = r + 7;
        c[n8] = c[n8] + values[this.getIndex(r + 7)];
    }

    protected final void preAggregateDDC_DDCSingleCol_vecChar(MapToChar tm, double[] td, double[] v, int r) {
        int r2 = r + 1;
        int r3 = r + 2;
        int r4 = r + 3;
        int r5 = r + 4;
        int r6 = r + 5;
        int r7 = r + 6;
        int r8 = r + 7;
        int n = this.getIndex(r);
        v[n] = v[n] + td[tm.getIndex(r)];
        int n2 = this.getIndex(r2);
        v[n2] = v[n2] + td[tm.getIndex(r2)];
        int n3 = this.getIndex(r3);
        v[n3] = v[n3] + td[tm.getIndex(r3)];
        int n4 = this.getIndex(r4);
        v[n4] = v[n4] + td[tm.getIndex(r4)];
        int n5 = this.getIndex(r5);
        v[n5] = v[n5] + td[tm.getIndex(r5)];
        int n6 = this.getIndex(r6);
        v[n6] = v[n6] + td[tm.getIndex(r6)];
        int n7 = this.getIndex(r7);
        v[n7] = v[n7] + td[tm.getIndex(r7)];
        int n8 = this.getIndex(r8);
        v[n8] = v[n8] + td[tm.getIndex(r8)];
    }

    @Override
    public AMapToData[] splitReshapeDDCPushDown(int multiplier, ExecutorService pool) throws Exception {
        int s = this.size();
        AMapToData[] ret = new MapToChar[multiplier];
        int eachSize = s / multiplier;
        for (int i = 0; i < multiplier; ++i) {
            ret[i] = new MapToChar(this.getUnique(), eachSize);
        }
        int blkz = Math.max(eachSize / 8, 2048) * multiplier;
        ArrayList tasks = new ArrayList();
        for (int i = 0; i < s; i += blkz) {
            int n = i;
            int end = Math.min(i + blkz, s);
            tasks.add(pool.submit(() -> this.lambda$splitReshapeDDCPushDown$0((MapToChar[])ret, multiplier, n, end)));
        }
        for (Future future : tasks) {
            future.get();
        }
        return ret;
    }

    private void splitReshapeDDCBlock(MapToChar[] ret, int multiplier, int start, int end) {
        for (int i = start; i < end; i += multiplier) {
            this.splitReshapeDDCRow(ret, multiplier, i);
        }
    }

    private void splitReshapeDDCRow(MapToChar[] ret, int multiplier, int i) {
        int off = i / multiplier;
        int end = i + multiplier;
        for (int j = i; j < end; ++j) {
            ret[j % multiplier]._data[off] = this._data[j];
        }
    }

    private /* synthetic */ void lambda$splitReshapeDDCPushDown$0(MapToChar[] ret, int multiplier, int start, int end) {
        this.splitReshapeDDCBlock(ret, multiplier, start, end);
    }
}

