/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.compress.colgroup.dictionary.DictionaryFactory;
import org.apache.sysds.runtime.compress.colgroup.indexes.ColIndexFactory;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToFactory;
import org.apache.sysds.runtime.compress.colgroup.offset.OffsetFactory;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.utils.MemoryEstimates;

public interface ColGroupSizes {
    public static final Log LOG = LogFactory.getLog((String)ColGroupSizes.class.getName());

    public static long estimateInMemorySizeGroup(int nrColumns, boolean contiguousColumns) {
        long size = 16L;
        return size += ColIndexFactory.estimateMemoryCost(nrColumns, contiguousColumns);
    }

    public static long estimateInMemorySizeGroupValue(int nrColumns, boolean contiguousColumns, int nrValues, double tupleSparsity, boolean lossy) {
        long size = ColGroupSizes.estimateInMemorySizeGroup(nrColumns, contiguousColumns);
        size += 8L;
        size += 8L;
        return size += DictionaryFactory.getInMemorySize(nrValues, nrColumns, tupleSparsity, lossy);
    }

    public static long estimateInMemorySizeDDC(int nrCols, boolean contiguousColumns, int numTuples, int dataLength, double tupleSparsity, boolean lossy) {
        long size = ColGroupSizes.estimateInMemorySizeGroupValue(nrCols, contiguousColumns, numTuples, tupleSparsity, lossy);
        return size += MapToFactory.estimateInMemorySize(dataLength, numTuples);
    }

    public static long estimateInMemorySizeOffset(int nrColumns, boolean contiguousColumns, int nrValues, int pointers, int offsetLength, double tupleSparsity, boolean lossy) {
        long size = ColGroupSizes.estimateInMemorySizeGroupValue(nrColumns, contiguousColumns, nrValues, tupleSparsity, lossy);
        size += 4L;
        ++size;
        size += 3L;
        size = (long)((double)size + MemoryEstimates.intArrayCost(pointers));
        size = (long)((double)size + MemoryEstimates.charArrayCost(offsetLength));
        return size;
    }

    public static long estimateInMemorySizeOLE(int nrColumns, boolean contiguousColumns, int nrValues, int offsetLength, int nrRows, double tupleSparsity, boolean lossy) {
        nrColumns = nrColumns > 0 ? nrColumns : 1;
        long size = ColGroupSizes.estimateInMemorySizeOffset(nrColumns, contiguousColumns, nrValues, nrValues + 1, offsetLength += nrRows / 65535 * 2, tupleSparsity, lossy);
        return size;
    }

    public static long estimateInMemorySizeRLE(int nrColumns, boolean contiguousColumns, int nrValues, int nrRuns, int nrRows, double tupleSparsity, boolean lossy) {
        if (nrRows > 65535) {
            double extra = (double)nrRows / 65535.0;
            nrRuns = (int)((double)nrRuns + extra / 2.0 * (double)nrValues);
        }
        return ColGroupSizes.estimateInMemorySizeOffset(nrColumns, contiguousColumns, nrValues, nrValues + 1, nrRuns * 2, tupleSparsity, lossy);
    }

    public static long estimateInMemorySizeSDC(int nrColumns, boolean contiguousColumns, int nrValues, int nrRows, int largestOff, double tupleSparsity, boolean largestOffZero, boolean lossy) {
        long size = ColGroupSizes.estimateInMemorySizeGroupValue(nrColumns, contiguousColumns, nrValues, tupleSparsity, lossy);
        size += OffsetFactory.estimateInMemorySize(nrRows - largestOff, nrRows);
        if (nrValues > 1 + (largestOffZero ? 0 : 1)) {
            size += MapToFactory.estimateInMemorySize(nrRows - largestOff, nrValues);
        }
        return size;
    }

    public static long estimateInMemorySizeCONST(int nrColumns, boolean contiguousColumns, double tupleSparsity, boolean lossy) {
        long size = ColGroupSizes.estimateInMemorySizeGroup(nrColumns, contiguousColumns);
        size += DictionaryFactory.getInMemorySize(1, nrColumns, tupleSparsity, lossy);
        return size += 8L;
    }

    public static long estimateInMemorySizeEMPTY(int nrColumns, boolean contiguousColumns) {
        return ColGroupSizes.estimateInMemorySizeGroup(nrColumns, contiguousColumns);
    }

    public static long estimateInMemorySizeUncompressed(int nrRows, boolean contiguousColumns, int nrColumns, double sparsity) {
        long size = 0L;
        size += ColGroupSizes.estimateInMemorySizeGroup(nrColumns, contiguousColumns);
        size += 8L;
        return size += MatrixBlock.estimateSizeInMemory((long)nrRows, (long)nrColumns, nrColumns > 1 ? sparsity : 1.0);
    }

    public static long estimateInMemorySizeLinearFunctional(int nrColumns, boolean contiguousColumns) {
        long size = 0L;
        size += ColGroupSizes.estimateInMemorySizeGroup(nrColumns, contiguousColumns);
        size = (long)((double)size + MemoryEstimates.doubleArrayCost(2L * (long)nrColumns));
        return size += 4L;
    }
}

