/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.estim.encoding;

import java.util.Arrays;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.compress.colgroup.indexes.IColIndex;
import org.apache.sysds.runtime.compress.colgroup.mapping.AMapToData;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToFactory;
import org.apache.sysds.runtime.compress.colgroup.offset.AOffset;
import org.apache.sysds.runtime.compress.colgroup.offset.OffsetFactory;
import org.apache.sysds.runtime.compress.estim.encoding.ConstEncoding;
import org.apache.sysds.runtime.compress.estim.encoding.DenseEncoding;
import org.apache.sysds.runtime.compress.estim.encoding.EmptyEncoding;
import org.apache.sysds.runtime.compress.estim.encoding.IEncode;
import org.apache.sysds.runtime.compress.estim.encoding.SparseEncoding;
import org.apache.sysds.runtime.compress.readers.ReaderColumnSelection;
import org.apache.sysds.runtime.compress.utils.DblArray;
import org.apache.sysds.runtime.compress.utils.DblArrayCountHashMap;
import org.apache.sysds.runtime.compress.utils.DoubleCountHashMap;
import org.apache.sysds.runtime.compress.utils.IntArrayList;
import org.apache.sysds.runtime.data.DenseBlock;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public interface EncodingFactory {
    public static final Log LOG = LogFactory.getLog((String)EncodingFactory.class.getName());

    public static IEncode createFromMatrixBlock(MatrixBlock m, boolean transposed, IColIndex rowCols) {
        if (m.isEmpty()) {
            return new EmptyEncoding();
        }
        if (rowCols.size() == 1) {
            return EncodingFactory.createFromMatrixBlock(m, transposed, rowCols.get(0));
        }
        return EncodingFactory.createWithReader(m, rowCols, transposed);
    }

    public static IEncode createFromMatrixBlockDelta(MatrixBlock m, boolean transposed, IColIndex rowCols) {
        throw new NotImplementedException();
    }

    public static IEncode createFromMatrixBlockDelta(MatrixBlock m, boolean transposed, IColIndex rowCols, int sampleSize) {
        throw new NotImplementedException();
    }

    public static IEncode createFromMatrixBlock(MatrixBlock m, boolean transposed, int rowCol) {
        if (m.isEmpty()) {
            return new EmptyEncoding();
        }
        if (transposed) {
            if (m.isInSparseFormat()) {
                return EncodingFactory.createFromSparseTransposed(m, rowCol);
            }
            return EncodingFactory.createFromDenseTransposed(m, rowCol);
        }
        if (m.isInSparseFormat()) {
            return EncodingFactory.createFromSparse(m, rowCol);
        }
        return EncodingFactory.createFromDense(m, rowCol);
    }

    private static IEncode createFromDenseTransposed(MatrixBlock m, int row) {
        DenseBlock db = m.getDenseBlock();
        if (!db.isContiguous()) {
            throw new NotImplementedException("Not Implemented non contiguous dense matrix encoding for sample");
        }
        DoubleCountHashMap map = new DoubleCountHashMap(16);
        int off = db.pos(row);
        int nCol = m.getNumColumns();
        int end = off + nCol;
        double[] vals = db.values(row);
        for (int i = off; i < end; ++i) {
            if (!Double.isNaN(vals[i])) {
                map.increment(vals[i]);
                continue;
            }
            map.increment(0.0);
        }
        int nUnique = map.size();
        if (nUnique == 1) {
            return new ConstEncoding(m.getNumColumns());
        }
        if (nUnique == 0) {
            return new EmptyEncoding();
        }
        if (map.getOrDefault(0.0, -1) > nCol / 4) {
            map.replaceWithUIDsNoZero();
            int zeroCount = map.get(0.0);
            int nV = nCol - zeroCount;
            IntArrayList offsets = new IntArrayList(nV);
            AMapToData d = MapToFactory.create(nV, nUnique - 1);
            int i = off;
            int r = 0;
            int di = 0;
            while (i < end) {
                if (vals[i] != 0.0) {
                    offsets.appendValue(r);
                    if (!Double.isNaN(vals[i])) {
                        d.set(di++, map.get(vals[i]));
                    } else {
                        d.set(di++, map.get(0.0));
                    }
                }
                ++i;
                ++r;
            }
            AOffset o = OffsetFactory.createOffset(offsets);
            return new SparseEncoding(d, o, nCol);
        }
        map.replaceWithUIDs();
        AMapToData d = MapToFactory.create(nCol, nUnique);
        int i = off;
        int r = 0;
        while (i < end) {
            if (!Double.isNaN(vals[i])) {
                d.set(r, map.get(vals[i]));
            } else {
                d.set(r, map.get(0.0));
            }
            ++i;
            ++r;
        }
        return new DenseEncoding(d);
    }

    private static IEncode createFromSparseTransposed(MatrixBlock m, int row) {
        DoubleCountHashMap map = new DoubleCountHashMap(16);
        SparseBlock sb = m.getSparseBlock();
        if (sb.isEmpty(row)) {
            return new EmptyEncoding();
        }
        int apos = sb.pos(row);
        int alen = sb.size(row) + apos;
        double[] avals = sb.values(row);
        int[] aix = sb.indexes(row);
        for (int i = apos; i < alen; ++i) {
            if (Double.isNaN(avals[i])) continue;
            map.increment(avals[i]);
        }
        int nUnique = map.size();
        map.replaceWithUIDs();
        int nCol = m.getNumColumns();
        if (nUnique == 0) {
            return new EmptyEncoding();
        }
        if (alen - apos > nCol / 4) {
            int correct = alen - apos == m.getNumColumns() ? 0 : 1;
            AMapToData d = MapToFactory.create(nCol, nUnique + correct);
            for (int i = apos; i < alen; ++i) {
                if (Double.isNaN(avals[i])) continue;
                d.set(aix[i], map.get(avals[i]) + correct);
            }
            return new DenseEncoding(d);
        }
        AMapToData d = MapToFactory.create(alen - apos, nUnique);
        int i = apos;
        int j = 0;
        while (i < alen) {
            if (!Double.isNaN(avals[i])) {
                d.set(j, map.get(avals[i]));
            }
            ++i;
            ++j;
        }
        AOffset o = OffsetFactory.createOffset(aix, apos, alen);
        return new SparseEncoding(d, o, m.getNumColumns());
    }

    private static IEncode createFromDense(MatrixBlock m, int col) {
        DenseBlock db = m.getDenseBlock();
        if (!db.isContiguous()) {
            throw new NotImplementedException("Not Implemented non contiguous dense matrix encoding for sample");
        }
        DoubleCountHashMap map = new DoubleCountHashMap(16);
        int off = col;
        int nCol = m.getNumColumns();
        int nRow = m.getNumRows();
        int end = off + nRow * nCol;
        double[] vals = m.getDenseBlockValues();
        for (int i = off; i < end; i += nCol) {
            if (!Double.isNaN(vals[i])) {
                map.increment(vals[i]);
                continue;
            }
            map.increment(0.0);
        }
        int nUnique = map.size();
        if (nUnique == 1) {
            return new ConstEncoding(m.getNumColumns());
        }
        if (map.getOrDefault(0.0, -1) > nRow / 4) {
            map.replaceWithUIDsNoZero();
            int zeroCount = map.get(0.0);
            int nV = m.getNumRows() - zeroCount;
            IntArrayList offsets = new IntArrayList(nV);
            AMapToData d = MapToFactory.create(nV, nUnique - 1);
            int i = off;
            int r = 0;
            int di = 0;
            while (i < end) {
                if (vals[i] != 0.0 && !Double.isNaN(vals[i])) {
                    offsets.appendValue(r);
                    d.set(di++, map.get(vals[i]));
                }
                i += nCol;
                ++r;
            }
            AOffset o = OffsetFactory.createOffset(offsets);
            return new SparseEncoding(d, o, nRow);
        }
        map.replaceWithUIDs();
        AMapToData d = MapToFactory.create(nRow, nUnique);
        int i = off;
        int r = 0;
        while (i < end) {
            if (!Double.isNaN(vals[i])) {
                d.set(r, map.get(vals[i]));
            } else {
                d.set(r, map.get(0.0));
            }
            i += nCol;
            ++r;
        }
        return new DenseEncoding(d);
    }

    private static IEncode createFromSparse(MatrixBlock m, int col) {
        DoubleCountHashMap map = new DoubleCountHashMap(16);
        SparseBlock sb = m.getSparseBlock();
        double guessedNumberOfNonZero = Math.min(4.0, Math.ceil((double)m.getNumRows() * m.getSparsity()));
        IntArrayList offsets = new IntArrayList((int)guessedNumberOfNonZero);
        for (int r = 0; r < m.getNumRows(); ++r) {
            double v;
            if (sb.isEmpty(r)) continue;
            int apos = sb.pos(r);
            int alen = sb.size(r) + apos;
            int[] aix = sb.indexes(r);
            int index = Arrays.binarySearch(aix, apos, alen, col);
            if (index < 0 || Double.isNaN(v = sb.values(r)[index])) continue;
            offsets.appendValue(r);
            map.increment(sb.values(r)[index]);
        }
        if (offsets.size() == 0) {
            return new EmptyEncoding();
        }
        int nUnique = map.size();
        map.replaceWithUIDs();
        AMapToData d = MapToFactory.create(offsets.size(), nUnique);
        int off = 0;
        int r = 0;
        while (off < offsets.size()) {
            if (!sb.isEmpty(r)) {
                int apos = sb.pos(r);
                int alen = sb.size(r) + apos;
                int[] aix = sb.indexes(r);
                int index = Arrays.binarySearch(aix, apos, alen, col);
                if (index >= 0) {
                    double v = sb.values(r)[index];
                    if (index >= 0 && !Double.isNaN(v)) {
                        d.set(off++, map.get(v));
                    }
                }
            }
            ++r;
        }
        AOffset o = OffsetFactory.createOffset(offsets);
        return new SparseEncoding(d, o, m.getNumRows());
    }

    private static IEncode createWithReader(MatrixBlock m, IColIndex rowCols, boolean transposed) {
        ReaderColumnSelection reader1 = ReaderColumnSelection.createReader(m, rowCols, transposed);
        int nRows = transposed ? m.getNumColumns() : m.getNumRows();
        DblArrayCountHashMap map = new DblArrayCountHashMap(16, rowCols.size());
        IntArrayList offsets = new IntArrayList();
        DblArray cellVals = reader1.nextRow();
        while (cellVals != null) {
            map.increment(cellVals);
            offsets.appendValue(reader1.getCurrentRowIndex());
            cellVals = reader1.nextRow();
        }
        if (offsets.size() == 0) {
            return new EmptyEncoding();
        }
        if (map.size() == 1 && offsets.size() == nRows) {
            return new ConstEncoding(nRows);
        }
        map.replaceWithUIDs();
        if (offsets.size() < nRows / 4) {
            return EncodingFactory.createWithReaderSparse(m, map, rowCols, offsets, nRows, transposed);
        }
        return EncodingFactory.createWithReaderDense(m, map, rowCols, nRows, transposed, offsets.size() < nRows);
    }

    private static IEncode createWithReaderDense(MatrixBlock m, DblArrayCountHashMap map, IColIndex rowCols, int nRows, boolean transposed, boolean zero) {
        int unique = map.size() + (zero ? 1 : 0);
        ReaderColumnSelection reader2 = ReaderColumnSelection.createReader(m, rowCols, transposed);
        AMapToData d = MapToFactory.create(nRows, unique);
        if (zero) {
            DblArray cellVals;
            while ((cellVals = reader2.nextRow()) != null) {
                d.set(reader2.getCurrentRowIndex(), map.get(cellVals) + 1);
            }
        } else {
            DblArray cellVals;
            while ((cellVals = reader2.nextRow()) != null) {
                d.set(reader2.getCurrentRowIndex(), map.get(cellVals));
            }
        }
        return new DenseEncoding(d);
    }

    private static IEncode createWithReaderSparse(MatrixBlock m, DblArrayCountHashMap map, IColIndex rowCols, IntArrayList offsets, int nRows, boolean transposed) {
        ReaderColumnSelection reader2 = ReaderColumnSelection.createReader(m, rowCols, transposed);
        DblArray cellVals = reader2.nextRow();
        AMapToData d = MapToFactory.create(offsets.size(), map.size());
        int i = 0;
        while (cellVals != null) {
            d.set(i++, map.get(cellVals));
            cellVals = reader2.nextRow();
        }
        AOffset o = OffsetFactory.createOffset(offsets);
        return new SparseEncoding(d, o, nRows);
    }

    public static SparseEncoding createSparse(AMapToData map, AOffset off, int nRows) {
        return new SparseEncoding(map, off, nRows);
    }
}

