/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup.offset;

import edu.emory.mathcs.backport.java.util.Arrays;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.sysds.runtime.compress.colgroup.AOffsetsGroup;
import org.apache.sysds.runtime.compress.colgroup.offset.AIterator;
import org.apache.sysds.runtime.compress.colgroup.offset.AOffset;
import org.apache.sysds.runtime.compress.colgroup.offset.AOffsetIterator;
import org.apache.sysds.runtime.compress.colgroup.offset.OffsetFactory;
import org.apache.sysds.utils.MemoryEstimates;

public class OffsetByte
extends AOffset {
    private static final long serialVersionUID = -4716104973912491790L;
    protected static final int maxV = 255;
    private final byte[] offsets;
    private final int offsetToFirst;
    private final int offsetToLast;
    private final int size;
    private final boolean noOverHalf;
    private final boolean noZero;

    protected OffsetByte(byte[] offsets, int offsetToFirst, int offsetToLast, int size, boolean noOverHalf, boolean noZero) {
        this.offsets = offsets;
        this.offsetToFirst = offsetToFirst;
        this.offsetToLast = offsetToLast;
        this.noOverHalf = noOverHalf;
        this.noZero = noZero;
        this.size = size;
    }

    @Override
    public AIterator getIterator() {
        if (this.noOverHalf) {
            return new IterateByteOffsetNoOverHalf();
        }
        if (this.noZero) {
            return new IterateByteOffsetNoZero();
        }
        return new IterateByteOffset();
    }

    @Override
    public AOffsetIterator getOffsetIterator() {
        if (this.noOverHalf) {
            return new OffsetByteIteratorNoOverHalf();
        }
        if (this.noZero) {
            return new OffsetByteIteratorNoZero();
        }
        return new OffsetByteIterator();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeByte(OffsetFactory.OFF_TYPE_SPECIALIZATIONS.BYTE.ordinal());
        out.writeInt(this.offsetToFirst);
        out.writeInt(this.offsets.length);
        out.writeInt(this.offsetToLast);
        out.writeInt(this.size);
        for (byte o : this.offsets) {
            out.writeByte(o);
        }
    }

    @Override
    public long getExactSizeOnDisk() {
        return 17 + this.offsets.length;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public int getOffsetToFirst() {
        return this.offsetToFirst;
    }

    @Override
    public int getOffsetToLast() {
        return this.offsetToLast;
    }

    @Override
    public long getInMemorySize() {
        return OffsetByte.estimateInMemorySize(this.offsets.length);
    }

    public static long estimateInMemorySize(int nOffs) {
        long size = 36L;
        size = (long)((double)size + MemoryEstimates.byteArrayCost(nOffs));
        return size;
    }

    public static OffsetByte readFields(DataInput in) throws IOException {
        int offsetToFirst = in.readInt();
        int offsetsLength = in.readInt();
        int offsetToLast = in.readInt();
        int size = in.readInt();
        byte[] offsets = new byte[offsetsLength];
        for (int i = 0; i < offsetsLength; ++i) {
            offsets[i] = in.readByte();
        }
        return new OffsetByte(offsets, offsetToFirst, offsetToLast, size, OffsetFactory.getNoOverHalf(offsets), OffsetFactory.getNoZero(offsets));
    }

    protected AOffset.OffsetSliceInfo slice(int lowOff, int highOff, int lowValue, int highValue, int low, int high) {
        int newSize = high - low + 1;
        byte[] newOffsets = Arrays.copyOfRange((byte[])this.offsets, (int)lowOff, (int)highOff);
        OffsetByte off = new OffsetByte(newOffsets, lowValue, highValue, newSize, this.noOverHalf, this.noZero);
        return new AOffset.OffsetSliceInfo(low, high + 1, off);
    }

    @Override
    protected AOffset moveIndex(int m) {
        return new OffsetByte(this.offsets, this.offsetToFirst - m, this.offsetToLast - m, this.size, this.noOverHalf, this.noZero);
    }

    @Override
    protected int getLength() {
        return this.offsets.length;
    }

    @Override
    public final AOffset appendN(AOffsetsGroup[] g, int s) {
        for (AOffsetsGroup gs : g) {
            AOffset a = gs.getOffsets();
            if (a instanceof OffsetByte) continue;
            return super.appendN(g, s);
        }
        int totalLength = g[0].getOffsets().getLength();
        for (int i = 1; i < g.length; ++i) {
            totalLength += g[i].getOffsets().getLength() + 1;
            int remainder = s - g[i - 1].getOffsets().getOffsetToLast();
            totalLength += (remainder + g[i].getOffsets().getOffsetToFirst() - 1) / 255;
        }
        byte[] ret = new byte[totalLength];
        int p = 0;
        int remainderLast = 0;
        int size = 0;
        boolean first = true;
        for (AOffsetsGroup gs : g) {
            OffsetByte b = (OffsetByte)gs.getOffsets();
            if (!first) {
                int offFirst = remainderLast + b.offsetToFirst;
                int div = offFirst / 255;
                int mod = offFirst % 255;
                if (mod == 0) {
                    p += div - 1;
                    ret[p++] = -1;
                } else {
                    p += div;
                    ret[p++] = (byte)mod;
                }
            }
            byte[] bd = b.offsets;
            System.arraycopy(bd, 0, ret, p, bd.length);
            remainderLast = s - b.offsetToLast;
            size += b.size;
            p += bd.length;
            first = false;
        }
        int offLast = s * (g.length - 1) + g[g.length - 1].getOffsets().getOffsetToLast();
        return new OffsetByte(ret, this.offsetToFirst, offLast, size, OffsetFactory.getNoOverHalf(ret), OffsetFactory.getNoZero(ret));
    }

    private class OffsetByteIteratorNoZero
    extends AOffsetIterator {
        protected int index;

        private OffsetByteIteratorNoZero() {
            super(OffsetByte.this.offsetToFirst);
            this.index = 0;
        }

        @Override
        public int next() {
            return this.offset += OffsetByte.this.offsets[this.index++] & 0xFF;
        }
    }

    private class OffsetByteIterator
    extends AOffsetIterator {
        protected int index;

        private OffsetByteIterator() {
            super(OffsetByte.this.offsetToFirst);
            this.index = 0;
        }

        @Override
        public int next() {
            byte v = OffsetByte.this.offsets[this.index];
            while (v == 0) {
                this.offset += 255;
                ++this.index;
                v = OffsetByte.this.offsets[this.index];
            }
            ++this.index;
            return this.offset += v & 0xFF;
        }
    }

    private class OffsetByteIteratorNoOverHalf
    extends AOffsetIterator {
        protected int index;

        private OffsetByteIteratorNoOverHalf() {
            super(OffsetByte.this.offsetToFirst);
            this.index = 0;
        }

        @Override
        public int next() {
            return this.offset += OffsetByte.this.offsets[this.index++];
        }
    }

    private class IterateByteOffsetNoOverHalf
    extends IterateByteOffsetNoZero {
        private IterateByteOffsetNoOverHalf() {
        }

        private IterateByteOffsetNoOverHalf(int index, int offset) {
            super(index, offset);
        }

        @Override
        public final int next() {
            this.offset += OffsetByte.this.offsets[this.index];
            ++this.index;
            return this.offset;
        }

        @Override
        public final int skipTo(int idx) {
            while (this.offset < idx && this.index < OffsetByte.this.offsets.length) {
                this.offset += OffsetByte.this.offsets[this.index];
                ++this.index;
            }
            return this.offset;
        }

        @Override
        public final IterateByteOffsetNoOverHalf clone() {
            return new IterateByteOffsetNoOverHalf(this.index, this.offset);
        }
    }

    private class IterateByteOffsetNoZero
    extends AIterator {
        protected int index;

        private IterateByteOffsetNoZero() {
            super(OffsetByte.this.offsetToFirst);
        }

        private IterateByteOffsetNoZero(int index, int offset) {
            super(offset);
            this.index = index;
        }

        @Override
        public int next() {
            byte v = OffsetByte.this.offsets[this.index];
            this.offset += v & 0xFF;
            ++this.index;
            return this.offset;
        }

        @Override
        public int skipTo(int idx) {
            while (this.offset < idx && this.index < OffsetByte.this.offsets.length) {
                this.next();
            }
            return this.offset;
        }

        @Override
        public IterateByteOffsetNoZero clone() {
            return new IterateByteOffsetNoZero(this.index, this.offset);
        }

        @Override
        public int getDataIndex() {
            return this.index;
        }

        @Override
        public int getOffsetsIndex() {
            return this.index;
        }
    }

    private class IterateByteOffset
    extends AIterator {
        protected int index;
        protected int dataIndex;

        private IterateByteOffset() {
            super(OffsetByte.this.offsetToFirst);
            this.index = 0;
            this.dataIndex = 0;
        }

        private IterateByteOffset(int index, int dataIndex, int offset) {
            super(offset);
            this.index = index;
            this.dataIndex = dataIndex;
        }

        @Override
        public int next() {
            byte v = OffsetByte.this.offsets[this.index];
            while (v == 0) {
                this.offset += 255;
                ++this.index;
                v = OffsetByte.this.offsets[this.index];
            }
            this.offset += v & 0xFF;
            ++this.index;
            ++this.dataIndex;
            return this.offset;
        }

        @Override
        public int skipTo(int idx) {
            if (idx < OffsetByte.this.offsetToLast) {
                while (this.offset < idx) {
                    this.next();
                }
            } else {
                while (this.offset < idx && this.index < OffsetByte.this.offsets.length) {
                    this.next();
                }
            }
            return this.offset;
        }

        @Override
        public IterateByteOffset clone() {
            return new IterateByteOffset(this.index, this.dataIndex, this.offset);
        }

        @Override
        public int getDataIndex() {
            return this.dataIndex;
        }

        @Override
        public int getOffsetsIndex() {
            return this.index;
        }
    }
}

