/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.metrics;

import java.io.Serializable;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import org.apache.spark.SparkEnv$;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.package$;
import org.apache.spark.memory.MemoryManager;
import org.apache.spark.metrics.ExecutorMetricType;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.math.Numeric;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class GarbageCollectionMetrics$
implements ExecutorMetricType,
Logging,
Product,
scala.Serializable {
    public static GarbageCollectionMetrics$ MODULE$;
    private Seq<String> youngGenerationGarbageCollector;
    private Seq<String> oldGenerationGarbageCollector;
    private Seq<String> nonBuiltInCollectors;
    private final Seq<String> names;
    private final Seq<String> YOUNG_GENERATION_BUILTIN_GARBAGE_COLLECTORS;
    private final Seq<String> OLD_GENERATION_BUILTIN_GARBAGE_COLLECTORS;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    static {
        new GarbageCollectionMetrics$();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Seq<String> nonBuiltInCollectors() {
        return this.nonBuiltInCollectors;
    }

    private void nonBuiltInCollectors_$eq(Seq<String> x$1) {
        this.nonBuiltInCollectors = x$1;
    }

    @Override
    public Seq<String> names() {
        return this.names;
    }

    public Seq<String> YOUNG_GENERATION_BUILTIN_GARBAGE_COLLECTORS() {
        return this.YOUNG_GENERATION_BUILTIN_GARBAGE_COLLECTORS;
    }

    public Seq<String> OLD_GENERATION_BUILTIN_GARBAGE_COLLECTORS() {
        return this.OLD_GENERATION_BUILTIN_GARBAGE_COLLECTORS;
    }

    private Seq<String> youngGenerationGarbageCollector$lzycompute() {
        GarbageCollectionMetrics$ garbageCollectionMetrics$ = this;
        synchronized (garbageCollectionMetrics$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.youngGenerationGarbageCollector = SparkEnv$.MODULE$.get().conf().get(package$.MODULE$.EVENT_LOG_GC_METRICS_YOUNG_GENERATION_GARBAGE_COLLECTORS());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.youngGenerationGarbageCollector;
    }

    private Seq<String> youngGenerationGarbageCollector() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.youngGenerationGarbageCollector$lzycompute() : this.youngGenerationGarbageCollector;
    }

    private Seq<String> oldGenerationGarbageCollector$lzycompute() {
        GarbageCollectionMetrics$ garbageCollectionMetrics$ = this;
        synchronized (garbageCollectionMetrics$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.oldGenerationGarbageCollector = SparkEnv$.MODULE$.get().conf().get(package$.MODULE$.EVENT_LOG_GC_METRICS_OLD_GENERATION_GARBAGE_COLLECTORS());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.oldGenerationGarbageCollector;
    }

    private Seq<String> oldGenerationGarbageCollector() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.oldGenerationGarbageCollector$lzycompute() : this.oldGenerationGarbageCollector;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long[] getMetricValues(MemoryManager memoryManager) {
        void var2_2;
        long[] gcMetrics = new long[this.names().length()];
        Buffer mxBeans = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(ManagementFactory.getGarbageCollectorMXBeans()).asScala();
        gcMetrics[4] = BoxesRunTime.unboxToLong((Object)((TraversableOnce)mxBeans.map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.getCollectionTime()), Buffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        mxBeans.foreach((Function1 & Serializable & scala.Serializable)mxBean -> {
            GarbageCollectionMetrics$.$anonfun$getMetricValues$2(gcMetrics, mxBean);
            return BoxedUnit.UNIT;
        });
        return var2_2;
    }

    public String productPrefix() {
        return "GarbageCollectionMetrics";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof GarbageCollectionMetrics$;
    }

    public int hashCode() {
        return 794585264;
    }

    public String toString() {
        return "GarbageCollectionMetrics";
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ void $anonfun$getMetricValues$2(long[] gcMetrics$1, GarbageCollectorMXBean mxBean) {
        block1: {
            block2: {
                block0: {
                    if (!MODULE$.youngGenerationGarbageCollector().contains((Object)mxBean.getName())) break block0;
                    gcMetrics$1[0] = mxBean.getCollectionCount();
                    gcMetrics$1[1] = mxBean.getCollectionTime();
                    break block1;
                }
                if (!MODULE$.oldGenerationGarbageCollector().contains((Object)mxBean.getName())) break block2;
                gcMetrics$1[2] = mxBean.getCollectionCount();
                gcMetrics$1[3] = mxBean.getCollectionTime();
                break block1;
            }
            if (MODULE$.nonBuiltInCollectors().contains((Object)mxBean.getName())) break block1;
            String string = mxBean.getName();
            MODULE$.nonBuiltInCollectors_$eq((Seq<String>)((Seq)MODULE$.nonBuiltInCollectors().$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom())));
            MODULE$.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(85).append("To enable non-built-in garbage collector(s) ").append(MODULE$.nonBuiltInCollectors()).append(", users should configure it(them) to ").append(package$.MODULE$.EVENT_LOG_GC_METRICS_YOUNG_GENERATION_GARBAGE_COLLECTORS().key()).append(" or ").append(package$.MODULE$.EVENT_LOG_GC_METRICS_OLD_GENERATION_GARBAGE_COLLECTORS().key()).toString());
        }
    }

    private GarbageCollectionMetrics$() {
        MODULE$ = this;
        Logging.$init$(this);
        Product.$init$((Product)this);
        this.nonBuiltInCollectors = Nil$.MODULE$;
        this.names = (Seq)new .colon.colon((Object)"MinorGCCount", (List)new .colon.colon((Object)"MinorGCTime", (List)new .colon.colon((Object)"MajorGCCount", (List)new .colon.colon((Object)"MajorGCTime", (List)new .colon.colon((Object)"TotalGCTime", (List)Nil$.MODULE$)))));
        this.YOUNG_GENERATION_BUILTIN_GARBAGE_COLLECTORS = (Seq)new .colon.colon((Object)"Copy", (List)new .colon.colon((Object)"PS Scavenge", (List)new .colon.colon((Object)"ParNew", (List)new .colon.colon((Object)"G1 Young Generation", (List)Nil$.MODULE$))));
        this.OLD_GENERATION_BUILTIN_GARBAGE_COLLECTORS = (Seq)new .colon.colon((Object)"MarkSweepCompact", (List)new .colon.colon((Object)"PS MarkSweep", (List)new .colon.colon((Object)"ConcurrentMarkSweep", (List)new .colon.colon((Object)"G1 Old Generation", (List)Nil$.MODULE$))));
    }
}

