/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.cocode;

import java.util.ArrayList;
import org.apache.sysds.runtime.compress.CompressionSettings;
import org.apache.sysds.runtime.compress.cocode.AColumnCoCoder;
import org.apache.sysds.runtime.compress.cocode.CoCodeBinPacking;
import org.apache.sysds.runtime.compress.cocode.CoCodeGreedy;
import org.apache.sysds.runtime.compress.cocode.CoCodeHybrid;
import org.apache.sysds.runtime.compress.cocode.CoCodePriorityQue;
import org.apache.sysds.runtime.compress.cocode.CoCodeStatic;
import org.apache.sysds.runtime.compress.cost.ACostEstimate;
import org.apache.sysds.runtime.compress.estim.CompressedSizeEstimator;
import org.apache.sysds.runtime.compress.estim.CompressedSizeInfo;
import org.apache.sysds.runtime.compress.estim.CompressedSizeInfoColGroup;
import org.apache.sysds.runtime.compress.utils.IntArrayList;

public interface CoCoderFactory {
    public static CompressedSizeInfo findCoCodesByPartitioning(CompressedSizeEstimator est, CompressedSizeInfo colInfos, int k, ACostEstimate costEstimator, CompressionSettings cs) {
        AColumnCoCoder co = CoCoderFactory.createColumnGroupPartitioner(cs.columnPartitioner, est, costEstimator, cs);
        boolean containsEmpty = false;
        for (CompressedSizeInfoColGroup g : colInfos.compressionInfo) {
            if (!g.isEmpty()) continue;
            containsEmpty = true;
            break;
        }
        if (!containsEmpty) {
            return co.coCodeColumns(colInfos, k);
        }
        IntArrayList emptyCols = new IntArrayList();
        ArrayList<CompressedSizeInfoColGroup> notEmpty = new ArrayList<CompressedSizeInfoColGroup>();
        for (CompressedSizeInfoColGroup g : colInfos.compressionInfo) {
            if (g.isEmpty()) {
                emptyCols.appendValue(g.getColumns()[0]);
                continue;
            }
            notEmpty.add(g);
        }
        int nRow = colInfos.compressionInfo.get(0).getNumRows();
        if (notEmpty.isEmpty()) {
            CompressedSizeInfoColGroup empty = new CompressedSizeInfoColGroup(emptyCols.extractValues(true), nRow);
            return new CompressedSizeInfo(empty);
        }
        colInfos.compressionInfo = notEmpty;
        colInfos = co.coCodeColumns(colInfos, k);
        colInfos.compressionInfo.add(new CompressedSizeInfoColGroup(emptyCols.extractValues(true), nRow));
        return colInfos;
    }

    private static AColumnCoCoder createColumnGroupPartitioner(PartitionerType type, CompressedSizeEstimator est, ACostEstimate costEstimator, CompressionSettings cs) {
        switch (type) {
            case AUTO: {
                return new CoCodeHybrid(est, costEstimator, cs);
            }
            case GREEDY: {
                return new CoCodeGreedy(est, costEstimator, cs);
            }
            case BIN_PACKING: {
                return new CoCodeBinPacking(est, costEstimator, cs);
            }
            case STATIC: {
                return new CoCodeStatic(est, costEstimator, cs);
            }
            case PRIORITY_QUE: {
                return new CoCodePriorityQue(est, costEstimator, cs);
            }
        }
        throw new RuntimeException("Unsupported column group partitioner: " + type.toString());
    }

    public static enum PartitionerType {
        BIN_PACKING,
        STATIC,
        PRIORITY_QUE,
        GREEDY,
        AUTO;

    }
}

