/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram.caching;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import org.apache.sysds.runtime.controlprogram.caching.CacheBlock;
import org.apache.sysds.runtime.controlprogram.caching.CacheDataInput;
import org.apache.sysds.runtime.controlprogram.caching.CacheDataOutput;
import org.apache.sysds.runtime.matrix.data.FrameBlock;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.util.LocalFileUtils;

public class ByteBuffer {
    private volatile boolean _serialized;
    private volatile boolean _shallow;
    private volatile boolean _matrix;
    private final long _size;
    protected byte[] _bdata = null;
    protected CacheBlock _cdata = null;

    public ByteBuffer(long size) {
        this._size = size;
        this._serialized = false;
    }

    public void serializeBlock(CacheBlock cb) throws IOException {
        this._shallow = cb.isShallowSerialize(true);
        this._matrix = cb instanceof MatrixBlock;
        try {
            if (!this._shallow) {
                if (this._bdata == null) {
                    this._bdata = new byte[(int)this._size];
                }
                CacheDataOutput dout = new CacheDataOutput(this._bdata);
                cb.write(dout);
            } else {
                if (!cb.isShallowSerialize()) {
                    cb.toShallowSerializeBlock();
                }
                this._cdata = cb;
            }
        }
        catch (Exception ex) {
            throw new IOException("Failed to serialize cache block.", ex);
        }
        this._serialized = true;
    }

    public CacheBlock deserializeBlock() throws IOException {
        CacheBlock ret = null;
        if (!this._shallow) {
            DataInput din = this._matrix ? new CacheDataInput(this._bdata) : new DataInputStream(new ByteArrayInputStream(this._bdata));
            ret = this._matrix ? new MatrixBlock() : new FrameBlock();
            ret.readFields(din);
        } else {
            ret = this._cdata;
        }
        return ret;
    }

    public void evictBuffer(String fname) throws IOException {
        if (!this._shallow) {
            LocalFileUtils.writeByteArrayToLocal(fname, this._bdata);
        } else {
            LocalFileUtils.writeCacheBlockToLocal(fname, this._cdata);
        }
    }

    public long getSize() {
        return this._size;
    }

    public boolean isShallow() {
        return this._shallow;
    }

    public void freeMemory() {
        if (!this._shallow) {
            this._bdata = null;
        } else {
            this._cdata = null;
        }
    }

    public void checkSerialized() {
        if (this._serialized) {
            return;
        }
        while (!this._serialized) {
            try {
                Thread.sleep(1L);
            }
            catch (Exception exception) {}
        }
    }

    public static boolean isValidCapacity(long size, CacheBlock cb) {
        if (!cb.isShallowSerialize(true)) {
            return size <= Integer.MAX_VALUE;
        }
        return true;
    }
}

