/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.spark.data;

import java.io.Serializable;
import java.util.ArrayList;
import org.apache.spark.broadcast.Broadcast;
import org.apache.sysml.runtime.controlprogram.caching.CacheBlock;
import org.apache.sysml.runtime.controlprogram.caching.CacheBlockFactory;
import org.apache.sysml.runtime.controlprogram.context.SparkExecutionContext;
import org.apache.sysml.runtime.instructions.spark.data.PartitionedBlock;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.data.OperationsOnMatrixValues;
import org.apache.sysml.runtime.matrix.data.Pair;
import org.apache.sysml.runtime.util.IndexRange;

public class PartitionedBroadcast<T extends CacheBlock>
implements Serializable {
    private static final long serialVersionUID = 7041959166079438401L;
    protected static final long BROADCAST_PARTSIZE = 0xF000000L;
    private Broadcast<PartitionedBlock<T>>[] _pbc = null;
    private MatrixCharacteristics _mc;

    public PartitionedBroadcast() {
    }

    public PartitionedBroadcast(Broadcast<PartitionedBlock<T>>[] broadcasts, MatrixCharacteristics mc) {
        this._pbc = broadcasts;
        this._mc = mc;
    }

    public Broadcast<PartitionedBlock<T>>[] getBroadcasts() {
        return this._pbc;
    }

    public long getNumRows() {
        return this._mc.getRows();
    }

    public long getNumCols() {
        return this._mc.getCols();
    }

    public int getNumRowBlocks() {
        return (int)this._mc.getNumRowBlocks();
    }

    public int getNumColumnBlocks() {
        return (int)this._mc.getNumColBlocks();
    }

    public static int computeBlocksPerPartition(long rlen, long clen, long brlen, long bclen) {
        return (int)Math.floor(0xF000000L / Math.min(rlen, brlen) / Math.min(clen, bclen));
    }

    public T getBlock(int rowIndex, int colIndex) {
        int pix = 0;
        if (this._pbc.length > 1) {
            int numPerPart = PartitionedBroadcast.computeBlocksPerPartition(this._mc.getRows(), this._mc.getCols(), this._mc.getRowsPerBlock(), this._mc.getColsPerBlock());
            int ix = (rowIndex - 1) * this.getNumColumnBlocks() + (colIndex - 1);
            pix = ix / numPerPart;
        }
        return ((PartitionedBlock)this._pbc[pix].value()).getBlock(rowIndex, colIndex);
    }

    public T slice(long rl, long ru, long cl, long cu, T block) {
        int lrl = (int)rl;
        int lru = (int)ru;
        int lcl = (int)cl;
        int lcu = (int)cu;
        ArrayList<?> allBlks = CacheBlockFactory.getPairList(block);
        int start_iix = (lrl - 1) / this._mc.getRowsPerBlock() + 1;
        int end_iix = (lru - 1) / this._mc.getRowsPerBlock() + 1;
        int start_jix = (lcl - 1) / this._mc.getColsPerBlock() + 1;
        int end_jix = (lcu - 1) / this._mc.getColsPerBlock() + 1;
        for (int iix = start_iix; iix <= end_iix; ++iix) {
            for (int jix = start_jix; jix <= end_jix; ++jix) {
                IndexRange ixrange = new IndexRange(rl, ru, cl, cu);
                allBlks.addAll(OperationsOnMatrixValues.performSlice(ixrange, this._mc.getRowsPerBlock(), this._mc.getColsPerBlock(), iix, jix, this.getBlock(iix, jix)));
            }
        }
        CacheBlock ret = (CacheBlock)((Pair)allBlks.get(0)).getValue();
        for (int i = 1; i < allBlks.size(); ++i) {
            ret.merge((CacheBlock)((Pair)allBlks.get(i)).getValue(), false);
        }
        return (T)ret;
    }

    public void destroy() {
        for (Broadcast<PartitionedBlock<T>> bvar : this._pbc) {
            SparkExecutionContext.cleanupBroadcastVariable(bvar);
        }
    }
}

