/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix.mapred;

import java.io.IOException;
import java.util.HashMap;
import java.util.Random;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.runtime.matrix.data.MatrixValue;
import org.apache.sysml.runtime.matrix.data.Pair;
import org.apache.sysml.runtime.matrix.mapred.MRConfigurationNames;
import org.apache.sysml.runtime.util.LocalFileUtils;
import org.apache.sysml.runtime.util.MapReduceTool;

public abstract class MMCJMRCache {
    protected Pair<MatrixIndexes, MatrixValue>[] _buffer = null;
    protected int _bufferCapacity = 0;
    protected int _bufferSize = 0;
    protected HashMap<MatrixIndexes, Integer> _bufferMap = null;
    protected JobConf _job = null;
    protected FileSystem _fs = null;
    protected int _fileCursor = -1;
    protected String _filePrefix = null;
    protected int _fileN = -1;

    public HashMap<MatrixIndexes, Integer> getBufferMap() {
        return this._bufferMap;
    }

    protected void allocateBuffer(int buffCapacity, Class<? extends MatrixValue> valueClass, boolean buffMap) throws IllegalAccessException, InstantiationException {
        this._bufferCapacity = buffCapacity;
        this._buffer = new Pair[this._bufferCapacity];
        for (int i = 0; i < this._bufferCapacity; ++i) {
            this._buffer[i] = new Pair<MatrixIndexes, MatrixValue>(new MatrixIndexes(), valueClass.newInstance());
        }
        if (buffMap) {
            this._bufferMap = new HashMap();
        }
    }

    protected void constructLocalFilePrefix(String fname) {
        String[] localDirs = this._job.get(MRConfigurationNames.MR_CLUSTER_LOCAL_DIR).split(",");
        Random rand = new Random();
        int randPos = rand.nextInt(localDirs.length);
        String hadoopLocalDir = localDirs[randPos];
        String uniqueSubDir = MapReduceTool.getGloballyUniqueName(this._job);
        this._filePrefix = new Path(hadoopLocalDir, uniqueSubDir + fname).toString();
    }

    protected Path getFilePath(int fileCursor) {
        Path path = new Path(this._filePrefix + fileCursor);
        return path;
    }

    protected void loadBuffer() throws IOException {
        Path path;
        this._bufferSize = 0;
        if (this._bufferMap != null) {
            this._bufferMap.clear();
        }
        if (this._fs.exists(path = this.getFilePath(this._fileCursor))) {
            this._bufferSize = LocalFileUtils.readBlockSequenceFromLocal(path.toString(), this._buffer, this._bufferMap);
        }
    }

    protected void writeBuffer() throws IOException {
        if (this._fileCursor < 0 || this._bufferSize <= 0) {
            return;
        }
        Path path = this.getFilePath(this._fileCursor);
        LocalFileUtils.writeBlockSequenceToLocal(path.toString(), this._buffer, this._bufferSize);
    }

    protected void deleteAllWorkingFiles() throws IOException {
        for (int i = 0; i < this._fileN; ++i) {
            Path ifile = new Path(this._filePrefix + i);
            MapReduceTool.deleteFileIfExistOnLFS(ifile, this._job);
        }
    }
}

